/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.cryptix.provider.key.DES_EDE3KeyGenerator;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import xjava.security.Cipher;

public class SshDotComPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private static Logger E = Logger.getLogger("SshDotComPrivateKeyFormat");
    private static final String D = "---- BEGIN SSH2 ENCRYPTED PRIVATE KEY ----";
    private static final String F = "---- END SSH2 ENCRYPTED PRIVATE KEY ----";
    private static final int G = 1064303083;
    private static final int C = 24;

    public SshDotComPrivateKeyFormat(String string, String string2) {
        super(D, F);
        this.setHeaderValue("Subject", string);
        this.setHeaderValue("Comment", string2);
    }

    public SshDotComPrivateKeyFormat() {
        super(D, F);
    }

    public String getFormatType() {
        return "SSH.COM-PrivateKey-" + super.getFormatType();
    }

    public boolean isPassphraseProtected(byte[] byArray) {
        try {
            byte[] byArray2 = this.getKeyBlob(byArray);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray2);
            byteArrayReader.readUINT32().intValue();
            byteArrayReader.readUINT32().intValue();
            byteArrayReader.readString();
            String string = byteArrayReader.readString();
            if (!string.equals("none")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            E.info("Unpacking ssh.com formatted private key");
            byte[] byArray2 = this.getKeyBlob(byArray);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray2);
            int n2 = byteArrayReader.readUINT32().intValue();
            if (n2 != 1064303083) {
                throw new InvalidSshKeyException("key file is broken");
            }
            byteArrayReader.readUINT32().intValue();
            String string2 = byteArrayReader.readString();
            String string3 = byteArrayReader.readString();
            byteArrayReader.readUINT32().intValue();
            if (string3.equalsIgnoreCase("3des-cbc")) {
                byte[] byArray3 = this.A(string, 24);
                object3 = Cipher.getInstance("DESede/CBC/NONE", "CryptixEDT");
                serializable = new DES_EDE3KeyGenerator().generateKey(byArray3);
                ((Cipher)object3).initDecrypt((Key)serializable);
                object2 = new ByteArrayOutputStream();
                int n3 = 0;
                while ((n3 = byteArrayReader.read()) != -1) {
                    ((ByteArrayOutputStream)object2).write(n3);
                }
                object = ((Cipher)object3).doFinal(((ByteArrayOutputStream)object2).toByteArray());
                byteArrayReader = new ByteArrayReader((byte[])object);
            } else if (!string3.equalsIgnoreCase("none")) {
                throw new InvalidSshKeyException("Unrecognized cipher '" + string3 + "'");
            }
            int n4 = byteArrayReader.readUINT32().intValue();
            if (n4 < 0) {
                throw new InvalidSshKeyException("Wrong passphrase for key");
            }
            if (string2.indexOf("if-modn") != -1) {
                E.info("RSA private key");
                object3 = byteArrayReader.readBigIntWithBits();
                serializable = byteArrayReader.readBigIntWithBits();
                object2 = byteArrayReader.readBigIntWithBits();
                byteArrayReader.readBigIntWithBits();
                byteArrayReader.readBigIntWithBits();
                byteArrayReader.readBigIntWithBits();
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-rsa");
                byteArrayWriter.writeBigInteger((BigInteger)object3);
                byteArrayWriter.writeBigInteger((BigInteger)object2);
                byteArrayWriter.writeBigInteger((BigInteger)serializable);
                return byteArrayWriter.toByteArray();
            }
            if (string2.indexOf("dl-modp") != -1) {
                if (byteArrayReader.readUINT32().intValue() != 0) {
                    throw new InvalidSshKeyException("DSS Private Key File is broken");
                }
                E.info("DSA private key");
                object3 = byteArrayReader.readBigIntWithBits();
                serializable = byteArrayReader.readBigIntWithBits();
                object2 = byteArrayReader.readBigIntWithBits();
                byteArrayReader.readBigIntWithBits();
                BigInteger bigInteger = byteArrayReader.readBigIntWithBits();
                object = new ByteArrayWriter();
                ((ByteArrayWriter)object).writeString("ssh-dss");
                ((ByteArrayWriter)object).writeBigInteger((BigInteger)object3);
                ((ByteArrayWriter)object).writeBigInteger((BigInteger)object2);
                ((ByteArrayWriter)object).writeBigInteger((BigInteger)serializable);
                ((ByteArrayWriter)object).writeBigInteger(bigInteger);
                return ((ByteArrayOutputStream)object).toByteArray();
            }
            throw new InvalidSshKeyException("Unknown authentication method '" + string2 + "'");
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key: " + exception.getMessage());
        }
    }

    private byte[] A(String string, int n2) {
        try {
            Object object;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5", "CryptixEDT");
            byte[] byArray = string.getBytes();
            int n3 = messageDigest.getDigestLength();
            byte[] byArray2 = new byte[(n2 + n3) / n3 * n3];
            for (int i2 = 0; i2 < n2; i2 += n3) {
                object = new ByteArrayOutputStream();
                ((ByteArrayOutputStream)object).write(byArray, 0, byArray.length);
                if (i2 > 0) {
                    ((ByteArrayOutputStream)object).write(byArray2, 0, i2);
                }
                messageDigest.update(((ByteArrayOutputStream)object).toByteArray());
                byte[] byArray3 = messageDigest.digest();
                System.arraycopy(byArray3, 0, byArray2, i2, n3);
            }
            object = new byte[n2];
            System.arraycopy(byArray2, 0, object, 0, n2);
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            E.error("Failed to convert passphrase", noSuchAlgorithmException);
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            E.error("Failed to convert passphrase", noSuchProviderException);
            return null;
        }
    }

    public byte[] encryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("encryptKeyblob() not implemented");
    }

    public boolean supportsAlgorithm(String string) {
        return true;
    }

    public String toString() {
        return this.getFormatType();
    }
}

