/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.InvalidHostFileException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static String B;
    private Logger D = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$HostKeyVerification == null ? (class$com$enterprisedt$net$j2ssh$transport$HostKeyVerification = AbstractKnownHostsKeyVerification.class$("com.enterprisedt.net.j2ssh.transport.HostKeyVerification")) : class$com$enterprisedt$net$j2ssh$transport$HostKeyVerification);
    private Map E = new HashMap();
    private String C;
    private boolean A = false;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$HostKeyVerification;

    public AbstractKnownHostsKeyVerification(String string) throws InvalidHostFileException, IOException {
        this.parse(string);
    }

    public AbstractKnownHostsKeyVerification() {
    }

    public void parse(InputStream inputStream) throws IOException {
        StringTokenizer stringTokenizer;
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null && (stringTokenizer = new StringTokenizer(string, " ")).countTokens() != 0) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.startsWith("#")) continue;
            stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            SshPublicKey sshPublicKey = SshKeyPairFactory.decodePublicKey(Base64.decode(string3));
            this.C(string2, sshPublicKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String string) throws IOException {
        InputStream inputStream = null;
        try {
            if (string != null) {
                File file = new File(string);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                    this.parse(inputStream);
                    inputStream.close();
                    this.A = file.canWrite();
                } else {
                    file.getParentFile().mkdirs();
                    if (file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(this.toString().getBytes());
                        fileOutputStream.close();
                        this.A = true;
                    } else {
                        this.A = false;
                    }
                }
                if (!this.A) {
                    this.D.warn("Host file is not writeable.");
                }
                this.C = string;
            }
            Object var6_5 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public boolean isHostFileWriteable() {
        return this.A;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract boolean onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public abstract boolean onUnknownAlgorithm(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String string, SshPublicKey sshPublicKey, boolean bl) throws InvalidHostFileException {
        if (this.D.isDebugEnabled()) {
            this.D.debug("Allowing " + string + " with fingerprint " + sshPublicKey.getFingerprint());
        }
        this.C(string, sshPublicKey);
        if (bl) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.E;
    }

    public void removeAllowedHost(String string) {
        Iterator iterator = this.E.keySet().iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (!string2.equals(string)) continue;
                this.E.remove(string2);
            }
        }
    }

    public void removeAllAllowedHosts() {
        this.E.clear();
    }

    public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        int n2;
        String string2 = sshPublicKey.getFingerprint();
        this.D.debug("Verifying " + string + " host key");
        if (this.D.isDebugEnabled()) {
            this.D.debug("Fingerprint: " + string2);
        }
        String string3 = (n2 = string.indexOf(",")) >= 0 ? string.substring(0, n2) : null;
        Iterator iterator = this.E.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string4.equalsIgnoreCase(string) || string3 != null && string4.equalsIgnoreCase(string3)) {
                return this.A(string4, sshPublicKey);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string5 = (String)stringTokenizer.nextElement();
                if (!string5.equalsIgnoreCase(string) && (string3 == null || !string5.equalsIgnoreCase(string3))) continue;
                return this.A(string4, sshPublicKey);
            }
        }
        this.onUnknownHost(string, sshPublicKey);
        return this.B(string, sshPublicKey);
    }

    public String getPreferredKeyAlgorithm(String string) {
        int n2 = string.indexOf(",");
        String string2 = n2 >= 0 ? string.substring(0, n2) : null;
        Iterator iterator = this.E.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Map map = (Map)this.E.get(string3);
            Iterator iterator2 = map.keySet().iterator();
            String string4 = null;
            string4 = iterator2.hasNext() ? (String)iterator2.next() : null;
            if (string3.equalsIgnoreCase(string) || string2 != null && string3.equalsIgnoreCase(string2)) {
                return string4;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string5 = (String)stringTokenizer.nextElement();
                if (!string5.equalsIgnoreCase(string) && (string2 == null || !string5.equalsIgnoreCase(string2))) continue;
                return string4;
            }
        }
        return null;
    }

    private boolean A(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        SshPublicKey sshPublicKey2 = this.A(string, sshPublicKey.getAlgorithmName());
        if (sshPublicKey2 != null && sshPublicKey.equals(sshPublicKey2)) {
            return true;
        }
        if (sshPublicKey2 == null) {
            if (!this.E.containsKey(string)) {
                return this.onUnknownHost(string, sshPublicKey);
            }
            return this.onUnknownAlgorithm(string, sshPublicKey);
        }
        this.onHostKeyMismatch(string, sshPublicKey2, sshPublicKey);
        return this.B(string, sshPublicKey);
    }

    private boolean B(String string, SshPublicKey sshPublicKey) {
        SshPublicKey sshPublicKey2 = this.A(string, sshPublicKey.getAlgorithmName());
        return sshPublicKey2 != null && sshPublicKey2.equals(sshPublicKey);
    }

    private SshPublicKey A(String string, String string2) {
        this.D.debug("getAllowedKey(names=" + string + ",algorithm=" + string2 + ")");
        if (this.E.containsKey(string)) {
            Map map = (Map)this.E.get(string);
            return (SshPublicKey)map.get(string2);
        }
        return null;
    }

    private void C(String string, SshPublicKey sshPublicKey) {
        this.D.debug("putAllowedKey(host=" + string + ",algorithm=" + sshPublicKey.getAlgorithmName() + ")");
        if (!this.E.containsKey(string)) {
            this.E.put(string, new HashMap());
        }
        Map map = (Map)this.E.get(string);
        map.put(sshPublicKey.getAlgorithmName(), sshPublicKey);
    }

    public Map getAllowedHosts() {
        return this.E;
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.A) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        this.D.debug("Saving " + B);
        try {
            File file = new File(this.C);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.C, iOException);
        }
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.E.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                SshPublicKey sshPublicKey = (SshPublicKey)entry2.getValue();
                string = string + entry.getKey().toString() + " " + sshPublicKey.getAlgorithmName() + " " + Base64.encodeBytes(sshPublicKey.getEncoded(), true) + "\n";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

