/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.InputStream;

public class SftpFileInputStream
extends InputStream {
    SftpFile B;
    UnsignedInteger64 A = new UnsignedInteger64("0");

    public SftpFileInputStream(SftpFile sftpFile) throws IOException {
        if (sftpFile.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (sftpFile.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.B = sftpFile;
    }

    public long skip(long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Only supports skipping up to 2147483647 bytes");
        }
        this.A = UnsignedInteger64.add(this.A, (int)l2);
        return l2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.B.getSFTPSubsystem().readFile(this.B.getHandle(), this.A, byArray, n2, n3);
        if (n4 > 0) {
            this.A = UnsignedInteger64.add(this.A, n4);
        }
        return n4;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.B.getSFTPSubsystem().readFile(this.B.getHandle(), this.A, byArray, 0, 1);
        this.A = UnsignedInteger64.add(this.A, n2);
        return byArray[0] & 0xFF;
    }

    public void close() throws IOException {
        this.B.close();
    }

    protected void finalize() throws IOException {
        if (this.B.getHandle() != null) {
            this.close();
        }
    }
}

