/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileAttributes {
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    private static final int N = 1;
    private static final int F = 2;
    private static final int K = 4;
    private static final int Q = 8;
    private static final int L = 0x8000000;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int R = 3;
    long I = 0L;
    int T;
    UnsignedInteger64 C = null;
    UnsignedInteger32 B = null;
    UnsignedInteger32 O = null;
    String M = null;
    String J = null;
    UnsignedInteger32 D = null;
    UnsignedInteger32 E = null;
    UnsignedInteger32 H = null;
    UnsignedInteger32 S = null;
    List G = new Vector();
    Map A = new HashMap();
    char[] P = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};

    public FileAttributes() {
    }

    public FileAttributes(ByteArrayReader byteArrayReader) throws IOException {
        this.I = byteArrayReader.readInt();
        if (this.isFlagSet(1)) {
            this.C = byteArrayReader.readUINT64();
        }
        if (this.isFlagSet(2)) {
            this.B = byteArrayReader.readUINT32();
            this.O = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(4)) {
            this.D = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(8)) {
            this.E = byteArrayReader.readUINT32();
            this.S = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(0x8000000)) {
            int n2 = (int)byteArrayReader.readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = byteArrayReader.readString();
                String string2 = byteArrayReader.readString();
                this.A.put(string, string2);
            }
        }
    }

    public UnsignedInteger32 getUID() {
        if (this.B != null) {
            return this.B;
        }
        return new UnsignedInteger32(0L);
    }

    public void setUID(UnsignedInteger32 unsignedInteger32) {
        this.I |= 2L;
        this.B = unsignedInteger32;
    }

    public void setGID(UnsignedInteger32 unsignedInteger32) {
        this.I |= 2L;
        this.O = unsignedInteger32;
    }

    public UnsignedInteger32 getGID() {
        if (this.O != null) {
            return this.O;
        }
        return new UnsignedInteger32(0L);
    }

    public void setSize(UnsignedInteger64 unsignedInteger64) {
        this.C = unsignedInteger64;
        this.I = unsignedInteger64 != null ? (this.I |= 1L) : (this.I ^= 1L);
    }

    public UnsignedInteger64 getSize() {
        if (this.C != null) {
            return this.C;
        }
        return new UnsignedInteger64("0");
    }

    public void setPermissions(UnsignedInteger32 unsignedInteger32) {
        this.D = unsignedInteger32;
        this.I = unsignedInteger32 != null ? (this.I |= 4L) : (this.I ^= 4L);
    }

    public void setPermissions(String string) {
        int n2;
        int n3 = 0;
        if (this.D != null) {
            n3 |= (this.D.intValue() & 0xF000) == 61440 ? 61440 : 0;
            n3 |= (this.D.intValue() & 0xC000) == 49152 ? 49152 : 0;
            n3 |= (this.D.intValue() & 0xA000) == 40960 ? 40960 : 0;
            n3 |= (this.D.intValue() & 0x8000) == 32768 ? 32768 : 0;
            n3 |= (this.D.intValue() & 0x6000) == 24576 ? 24576 : 0;
            n3 |= (this.D.intValue() & 0x4000) == 16384 ? 16384 : 0;
            n3 |= (this.D.intValue() & 0x2000) == 8192 ? 8192 : 0;
            n3 |= (this.D.intValue() & 0x1000) == 4096 ? 4096 : 0;
            n3 |= (this.D.intValue() & 0x800) == 2048 ? 2048 : 0;
            n3 |= (this.D.intValue() & 0x400) == 1024 ? 1024 : 0;
        }
        if ((n2 = string.length()) >= 1) {
            n3 |= string.charAt(0) == 'r' ? 256 : 0;
        }
        if (n2 >= 2) {
            n3 |= string.charAt(1) == 'w' ? 128 : 0;
        }
        if (n2 >= 3) {
            n3 |= string.charAt(2) == 'x' ? 64 : 0;
        }
        if (n2 >= 4) {
            n3 |= string.charAt(3) == 'r' ? 32 : 0;
        }
        if (n2 >= 5) {
            n3 |= string.charAt(4) == 'w' ? 16 : 0;
        }
        if (n2 >= 6) {
            n3 |= string.charAt(5) == 'x' ? 8 : 0;
        }
        if (n2 >= 7) {
            n3 |= string.charAt(6) == 'r' ? 4 : 0;
        }
        if (n2 >= 8) {
            n3 |= string.charAt(7) == 'w' ? 2 : 0;
        }
        if (n2 >= 9) {
            n3 |= string.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(n3));
    }

    public UnsignedInteger32 getPermissions() {
        return this.D;
    }

    public void setTimes(UnsignedInteger32 unsignedInteger32, UnsignedInteger32 unsignedInteger322) {
        this.E = unsignedInteger32;
        this.S = unsignedInteger322;
        this.I = unsignedInteger32 != null ? (this.I |= 8L) : (this.I ^= 8L);
    }

    public UnsignedInteger32 getAccessedTime() {
        return this.E;
    }

    public UnsignedInteger32 getModifiedTime() {
        if (this.S != null) {
            return this.S;
        }
        return new UnsignedInteger32(0L);
    }

    public Map getExtendedAttributes() {
        return this.A;
    }

    public boolean isFlagSet(int n2) {
        return (this.I & (long)n2) == (long)n2;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (this.A.size() > 0) {
            this.I |= 0x8000000L;
        }
        byteArrayWriter.writeInt(this.I);
        if (this.isFlagSet(1)) {
            byteArrayWriter.writeUINT64(this.C);
        }
        if (this.isFlagSet(2)) {
            if (this.B != null) {
                byteArrayWriter.writeUINT32(this.B);
            } else {
                byteArrayWriter.writeInt(0);
            }
            if (this.O != null) {
                byteArrayWriter.writeUINT32(this.O);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        if (this.isFlagSet(4)) {
            byteArrayWriter.writeUINT32(this.D);
        }
        if (this.isFlagSet(8)) {
            byteArrayWriter.writeUINT32(this.E);
            byteArrayWriter.writeUINT32(this.S);
        }
        if (this.isFlagSet(0x8000000)) {
            byteArrayWriter.writeInt(this.A.size());
            Iterator iterator = this.A.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                byteArrayWriter.writeString((String)entry.getKey());
                byteArrayWriter.writeString((String)entry.getValue());
            }
        }
        return byteArrayWriter.toByteArray();
    }

    private int A(int n2, int n3) {
        return (((n2 >>>= n3) & 4) != 0 ? 4 : 0) + ((n2 & 2) != 0 ? 2 : 0) + ((n2 & 1) != 0 ? 1 : 0);
    }

    private String B(int n2, int n3) {
        String string = (((n2 >>>= n3) & 4) != 0 ? "r" : "-") + ((n2 & 2) != 0 ? "w" : "-");
        string = n3 == 6 && (this.D.intValue() & 0x800) == 2048 || n3 == 3 && (this.D.intValue() & 0x400) == 1024 ? string + ((n2 & 1) != 0 ? "s" : "S") : string + ((n2 & 1) != 0 ? "x" : "-");
        return string;
    }

    public String getPermissionsString() {
        if (this.D != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.P[(this.D.intValue() & 0xF000) >>> 13]);
            stringBuffer.append(this.B(this.D.intValue(), 6));
            stringBuffer.append(this.B(this.D.intValue(), 3));
            stringBuffer.append(this.B(this.D.intValue(), 0));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0');
        int n2 = this.D.intValue();
        stringBuffer.append(this.A(n2, 6));
        stringBuffer.append(this.A(n2, 3));
        stringBuffer.append(this.A(n2, 0));
        return stringBuffer.toString();
    }

    public String getModTimeString() {
        if (this.S == null) {
            return "";
        }
        long l2 = this.S.longValue() * 1000L;
        long l3 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = l3 - l2 > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return simpleDateFormat.format(new Date(l2));
    }

    public boolean isDirectory() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        if (this.D == null) {
            return false;
        }
        return (this.D.intValue() & 0xC000) == 49152;
    }
}

