/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.openssh.KeyInfo;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyInfo
implements KeyInfo {
    private BigInteger G;
    private BigInteger J;
    private BigInteger F;
    private BigInteger M;
    private BigInteger L;
    private BigInteger I;
    private BigInteger H;
    private BigInteger K;

    public RSAKeyInfo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.G = bigInteger;
        this.J = bigInteger2;
        this.F = bigInteger3;
        this.M = bigInteger4;
        this.L = bigInteger5;
        this.I = bigInteger6;
        this.H = bigInteger7;
        this.K = bigInteger8;
    }

    public KeySpec getPrivateKeySpec() {
        return new RSAPrivateKeySpec(this.G, this.F);
    }

    public KeySpec getPublicKeySpec() {
        return new RSAPublicKeySpec(this.G, this.J);
    }

    public BigInteger getCrtCoefficient() {
        return this.K;
    }

    public BigInteger getModulus() {
        return this.G;
    }

    public BigInteger getPrimeExponentP() {
        return this.I;
    }

    public BigInteger getPrimeExponentQ() {
        return this.H;
    }

    public BigInteger getPrimeP() {
        return this.M;
    }

    public BigInteger getPrimeQ() {
        return this.L;
    }

    public BigInteger getPrivateExponent() {
        return this.F;
    }

    public BigInteger getPublicExponent() {
        return this.J;
    }

    public static RSAKeyInfo getRSAKeyInfo(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray2 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray3 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray4 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray5 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray6 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray7 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray8 = simpleASNReader.getData();
        return new RSAKeyInfo(new BigInteger(byArray), new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8));
    }

    public static void writeRSAKeyInfo(SimpleASNWriter simpleASNWriter, RSAKeyInfo rSAKeyInfo) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getModulus().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPublicExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrivateExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeExponentP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getPrimeExponentQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rSAKeyInfo.getCrtCoefficient().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }
}

