/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Properties;

public class PublicKeyAuthenticationClient
extends SshAuthenticationClient {
    private static Logger C = Logger.getLogger(class$com$enterprisedt$net$j2ssh$authentication$PublicKeyAuthenticationClient == null ? (class$com$enterprisedt$net$j2ssh$authentication$PublicKeyAuthenticationClient = PublicKeyAuthenticationClient.class$("com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient")) : class$com$enterprisedt$net$j2ssh$authentication$PublicKeyAuthenticationClient);
    protected SshPrivateKey key;
    private String D = null;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$PublicKeyAuthenticationClient;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthPKOK;

    public void setKey(SshPrivateKey sshPrivateKey) {
        this.key = sshPrivateKey;
    }

    public void setKeyfile(String string) {
        this.D = string;
    }

    public String getKeyfile() {
        return this.D;
    }

    public void reset() {
        this.D = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authenticationProtocolClient, String string, String string2, SshPublicKey sshPublicKey) throws IOException {
        authenticationProtocolClient.registerMessage(class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthPKOK == null ? (class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthPKOK = PublicKeyAuthenticationClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthPKOK")) : class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthPKOK, 60);
        C.debug("Determining if server can accept public key for authentication");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(0);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMessage);
        try {
            sshMessage = authenticationProtocolClient.readMessage(60);
            if (sshMessage instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException terminatedStateException) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        C.debug("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        C.debug("Preparing public key authentication request");
        byteArrayWriter.write(1);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(string);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.write(1);
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.D != null) {
            properties.setProperty("PrivateKey", this.D);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.D = properties.getProperty("PrivateKey");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

