/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;

public class HostbasedAuthenticationClient
extends SshAuthenticationClient {
    private static Logger I = Logger.getLogger(class$com$enterprisedt$net$j2ssh$authentication$HostbasedAuthenticationClient == null ? (class$com$enterprisedt$net$j2ssh$authentication$HostbasedAuthenticationClient = HostbasedAuthenticationClient.class$("com.enterprisedt.net.j2ssh.authentication.HostbasedAuthenticationClient")) : class$com$enterprisedt$net$j2ssh$authentication$HostbasedAuthenticationClient);
    protected SshPrivateKey key;
    private String J = null;
    private String H = null;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$HostbasedAuthenticationClient;

    public void setKey(SshPrivateKey sshPrivateKey) {
        this.key = sshPrivateKey;
    }

    public void reset() {
        this.J = null;
        this.H = null;
    }

    public void setClientUsername(String string) {
        this.H = string;
    }

    public String getMethodName() {
        return "hostbased";
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        I.debug("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string2 = inetAddress.getHostName();
        I.debug("Preparing hostbased authentication request for " + string2);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeString(string2);
        if (this.H != null) {
            byteArrayWriter.writeString(this.H);
        } else {
            byteArrayWriter.writeString(this.getUsername());
        }
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(string);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter2.writeString(string2);
        if (this.H != null) {
            byteArrayWriter2.writeString(this.H);
        } else {
            byteArrayWriter2.writeString(this.getUsername());
        }
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.J != null) {
            properties.setProperty("PrivateKey", this.J);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.J = properties.getProperty("PrivateKey");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

