/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import java.util.Date;
import java.util.Vector;

public class SSLFTPStandardValidator
implements SSLFTPValidator {
    public static int MAX_CERTIFICATE_CHAIN_LENGTH = 2;
    protected boolean hostNameCheckingEnabled = true;
    protected String serverCommonName = null;
    protected SSLFTPCertificateStore rootCertificateStore;

    public SSLFTPStandardValidator() {
    }

    public SSLFTPStandardValidator(String string) {
        this.serverCommonName = string;
    }

    public SSLFTPStandardValidator(boolean bl) {
        this.hostNameCheckingEnabled = bl;
    }

    void A(SSLFTPCertificateStore sSLFTPCertificateStore) {
        this.rootCertificateStore = sSLFTPCertificateStore;
    }

    protected boolean checkChainLength(int n2) {
        return n2 <= MAX_CERTIFICATE_CHAIN_LENGTH;
    }

    protected boolean checkCommonName(String string, String string2) {
        if (this.serverCommonName != null) {
            return string.toLowerCase().equals(this.serverCommonName.toLowerCase());
        }
        return !this.hostNameCheckingEnabled || string.toLowerCase().equals(string2.toLowerCase());
    }

    protected boolean checkDateRange(Date date, Date date2) {
        Date date3 = new Date();
        return !date3.before(date) && !date3.after(date2);
    }

    public boolean validateServerCertificate(boolean bl, Vector vector, String string) throws SSLFTPException {
        if (!bl) {
            return false;
        }
        if (!this.checkChainLength(vector.size())) {
            throw new SSLFTPException("The server's certificate chain is too long");
        }
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)vector.lastElement();
        String string2 = sSLFTPCertificate.getSubjectName().getCommonName();
        if (!this.checkCommonName(string2, string)) {
            throw new SSLFTPException("The CN (Common Name), " + string2 + ", on the server's certificate does not match its hostname, " + string + ".");
        }
        if (!this.checkDateRange(sSLFTPCertificate.getValidityNotBefore(), sSLFTPCertificate.getValidityNotAfter())) {
            throw new SSLFTPException("The server's certificate is not currently valid.  It is valid from " + sSLFTPCertificate.getValidityNotBefore() + " until " + sSLFTPCertificate.getValidityNotAfter() + ".  " + "This computer indicates the current date/time is " + new Date().toString() + ".");
        }
        return true;
    }
}

