/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class SSLFTPCertificateStore
implements List {
    private Logger B = Logger.getLogger(class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore == null ? (class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore = SSLFTPCertificateStore.class$("com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore")) : class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore);
    private Vector C = new Vector();
    private _A A;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificate;

    public void importPEMFile(String string) throws FileNotFoundException, IOException, SSLFTPCertificateException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.importPEMFile(fileInputStream);
        fileInputStream.close();
    }

    public void importPEMFile(InputStream inputStream) throws IOException, SSLFTPCertificateException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            X509Cert x509Cert = new X509Cert(byArray);
            this.C.add(new SSLFTPCertificate(x509Cert));
        }
        this.A();
    }

    public void exportPEMFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.exportPEMFile(fileOutputStream);
        fileOutputStream.close();
    }

    public void exportPEMFile(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)iterator.next();
            bufferedWriter.write(sSLFTPCertificate.toString(true) + "\n");
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(sSLFTPCertificate.getCertDER(), "CERTIFICATE", bufferedWriter);
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    public void importKeyStore(KeyStore keyStore) throws KeyStoreException, SSLFTPException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
            this.add(new SSLFTPCertificate(certificate));
        }
    }

    public void exportKeyStore(KeyStore keyStore) throws CertificateException, KeyStoreException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)iterator.next();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sSLFTPCertificate.writePEM(byteArrayOutputStream);
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                FileOutputStream fileOutputStream = new FileOutputStream("D:\\Temp\\test.pem");
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                String string = sSLFTPCertificate.getSubjectName().getCommonName();
                if (string == null) {
                    string = sSLFTPCertificate.getSubjectName().getOrganisationName();
                }
                keyStore.setCertificateEntry(string, certificate);
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                this.B.error("Error while exporting to KeyStore", iOException);
            }
        }
    }

    private void A(Object object) {
        if (!(object instanceof SSLFTPCertificate)) {
            throw new ArrayStoreException("Cannot add an instance of " + object.getClass().toString() + " to a " + (class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore == null ? (class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore = SSLFTPCertificateStore.class$("com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore")) : class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificateStore).toString() + " - must be " + (class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificate == null ? (class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificate = SSLFTPCertificateStore.class$("com.enterprisedt.net.ftp.ssl.SSLFTPCertificate")) : class$com$enterprisedt$net$ftp$ssl$SSLFTPCertificate).toString());
        }
    }

    public void add(int n2, Object object) {
        this.A(object);
        this.C.add(n2, object);
        this.A();
    }

    public boolean add(Object object) {
        this.A(object);
        this.C.add(object);
        this.A();
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.A(iterator.next());
        }
        this.C.addAll(collection);
        this.A();
        return true;
    }

    public boolean addAll(int n2, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.A(iterator.next());
        }
        this.C.addAll(n2, collection);
        this.A();
        return true;
    }

    public void clear() {
        this.C.clear();
        this.A();
    }

    public boolean contains(Object object) {
        this.A(object);
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)object;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SSLFTPCertificate sSLFTPCertificate2 = (SSLFTPCertificate)iterator.next();
            if (!sSLFTPCertificate2.equals(sSLFTPCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains((SSLFTPCertificate)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int n2) {
        return this.C.get(n2);
    }

    public SSLFTPCertificate getCertificate(int n2) {
        return (SSLFTPCertificate)this.C.get(n2);
    }

    public int indexOf(Object object) {
        return this.C.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.C.lastIndexOf(object);
    }

    public boolean isEmpty() {
        return this.C.isEmpty();
    }

    public Iterator iterator() {
        return this.C.iterator();
    }

    public ListIterator listIterator() {
        return this.C.listIterator();
    }

    public ListIterator listIterator(int n2) {
        return this.C.listIterator(n2);
    }

    public Object remove(int n2) {
        Object e2 = this.C.remove(n2);
        if (e2 != null) {
            this.A();
        }
        return e2;
    }

    public SSLFTPCertificate removeCertificate(int n2) {
        SSLFTPCertificate sSLFTPCertificate = (SSLFTPCertificate)this.C.remove(n2);
        if (sSLFTPCertificate != null) {
            this.A();
        }
        return sSLFTPCertificate;
    }

    public boolean remove(Object object) {
        if (this.C.remove(object)) {
            this.A();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (this.C.removeAll(collection)) {
            this.A();
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection collection) {
        if (this.C.retainAll(collection)) {
            this.A();
            return true;
        }
        return false;
    }

    public Object set(int n2, Object object) {
        this.A(object);
        Object object2 = this.C.set(n2, object);
        if (object2 != null) {
            this.A();
        }
        return object2;
    }

    public int size() {
        return this.C.size();
    }

    public List subList(int n2, int n3) {
        return this.C.subList(n2, n3);
    }

    public Object[] toArray() {
        return this.C.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.C.toArray(objectArray);
    }

    public SSLFTPCertificate[] toCertificateArray() {
        SSLFTPCertificate[] sSLFTPCertificateArray = new SSLFTPCertificate[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sSLFTPCertificateArray[i2] = this.getCertificate(i2);
        }
        return sSLFTPCertificateArray;
    }

    void A(_A _A2) {
        this.A = _A2;
    }

    void A() {
        if (this.A != null) {
            this.A.A(this);
        }
    }

    Vector B() {
        Vector<X509Cert> vector = new Vector<X509Cert>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            vector.add(((SSLFTPCertificate)iterator.next()).A());
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface _A {
        public void A(SSLFTPCertificateStore var1);
    }
}

