/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import java.io.IOException;
import java.io.OutputStream;

public class SSHFTPPublicKey
extends SSHFTPValidator {
    public static final int OPENSSH_FORMAT = 0;
    public static final int IETF_SECSH_FORMAT = 1;
    private SshPublicKey E;

    SSHFTPPublicKey(SshPublicKey sshPublicKey) {
        this.E = sshPublicKey;
    }

    public String getAlgorithmName() {
        return this.E.getAlgorithmName();
    }

    public int getBitLength() {
        return this.E.getBitLength();
    }

    public byte[] getKeyData() {
        return this.E.getEncoded();
    }

    public String getFingerprint() {
        return this.E.getFingerprint();
    }

    public boolean equals(Object object) {
        return this.E.equals(object);
    }

    public int hashCode() {
        return this.E.hashCode();
    }

    public int write(OutputStream outputStream, int n2) throws SSHFTPException, IOException {
        SshPublicKeyFormat sshPublicKeyFormat = null;
        try {
            switch (n2) {
                case 0: {
                    sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance("OpenSSH-PublicKey");
                    break;
                }
                case 1: {
                    sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance("SECSH-PublicKey-Base64Encoded");
                }
            }
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw new SSHFTPException("Internal inconsistency in SSHFTPPublicKey.write: " + invalidSshKeyException.getMessage());
        }
        if (sshPublicKeyFormat == null) {
            throw new SSHFTPException("Unsupported key format-code: " + sshPublicKeyFormat);
        }
        byte[] byArray = sshPublicKeyFormat.formatKey(this.E.getEncoded());
        outputStream.write(byArray);
        return byArray.length;
    }
}

