/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.59 2006/10/11 08:38:00 bruceb Exp $";
    private static final int B = 65535;
    private static final int M = 16384;
    private static final int V = 65535;
    private static final int D = 500;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String H = "socksProxyPort";
    private static final String U = "socksProxyHost";
    private static final byte[] b = System.getProperty("line.separator").getBytes();
    private static final byte Z = 13;
    private static final byte P = 10;
    private static final String c = "NO FILES";
    private static final String K = "NO SUCH FILE OR DIRECTORY";
    private static final String C = "EMPTY";
    private static final String _ = "NO DATA SETS FOUND";
    private static final String[] a = new String[]{"NO FILES", "NO SUCH FILE OR DIRECTORY", "EMPTY", "NO DATA SETS FOUND"};
    private static final String T = "TRANSFER COMPLETE";
    private static Logger G = Logger.getLogger(class$com$enterprisedt$net$ftp$FTPClient == null ? (class$com$enterprisedt$net$ftp$FTPClient = FTPClient.class$("com.enterprisedt.net.ftp.FTPClient")) : class$com$enterprisedt$net$ftp$FTPClient);
    private SimpleDateFormat O = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    protected int timeout = 0;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected int controlPort = 21;
    private boolean A = false;
    protected String controlEncoding = "US-ASCII";
    private boolean I = true;
    private boolean Y = false;
    private boolean J = false;
    private long R = 0L;
    private boolean Q = false;
    private long F = 65535L;
    private int S = 16384;
    private FTPFileFactory X = null;
    private Locale E = Locale.getDefault();
    private FTPProgressMonitor W = null;
    protected FTPMessageListener messageListener = null;
    private FTPTransferType L = FTPTransferType.ASCII;
    private FTPConnectMode N = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$FTPClient;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String string) throws IOException, FTPException {
        this(string, 21, 0);
    }

    public FTPClient(String string, int n2) throws IOException, FTPException {
        this(string, n2, 0);
    }

    public FTPClient(String string, int n2, int n3) throws IOException, FTPException {
        this(InetAddress.getByName(string), n2, n3);
    }

    public FTPClient(String string, int n2, int n3, String string2) throws IOException, FTPException {
        this(InetAddress.getByName(string), n2, n3, string2);
    }

    public FTPClient(InetAddress inetAddress) throws IOException, FTPException {
        this(inetAddress, 21, 0);
    }

    public FTPClient(InetAddress inetAddress, int n2) throws IOException, FTPException {
        this(inetAddress, n2, 0);
    }

    public FTPClient(InetAddress inetAddress, int n2, int n3) throws IOException, FTPException {
        this.O.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (n2 < 0) {
            n2 = 21;
        }
        this.initialize(new FTPControlSocket(inetAddress, n2, n3, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress inetAddress, int n2, int n3, String string) throws IOException, FTPException {
        this.O.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (n2 < 0) {
            n2 = 21;
        }
        this.initialize(new FTPControlSocket(inetAddress, n2, n3, string, null));
    }

    public FTPClient() {
        this.O.setTimeZone(TimeZone.getTimeZone("GMT"));
        G.debug(VersionDetails.report(this));
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        G.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public boolean connected() {
        return this.control != null;
    }

    protected void checkConnection(boolean bl) throws FTPException {
        if (bl && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!bl && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket fTPControlSocket) throws IOException {
        this.control = fTPControlSocket;
        fTPControlSocket.A(this.messageListener);
        fTPControlSocket.A(this.I);
        fTPControlSocket.A(this.timeout);
        fTPControlSocket.setAutoPassiveIPSubstitution(this.A);
    }

    public void debugResponses(boolean bl) {
        if (bl) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public void setStrictReturnCodes(boolean bl) {
        this.I = bl;
        if (this.control != null) {
            this.control.A(bl);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.I;
    }

    public void setDetectTransferMode(boolean bl) {
        this.Q = bl;
    }

    public boolean getDetectTransferMode() {
        return this.Q;
    }

    private void B(String string) {
        if (this.Q) {
            if (FileTypes.ASCII.matches(string) && this.L.equals(FTPTransferType.BINARY)) {
                this.L = FTPTransferType.ASCII;
                G.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(string) && this.L.equals(FTPTransferType.ASCII)) {
                this.L = FTPTransferType.BINARY;
                G.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    public void setTimeout(int n2) throws IOException {
        this.timeout = n2;
        if (this.control != null) {
            this.control.A(n2);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.controlPort;
    }

    public void setRemotePort(int n2) throws FTPException {
        this.checkConnection(false);
        this.controlPort = n2;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int n2) throws FTPException {
        this.checkConnection(false);
        this.controlPort = n2;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress inetAddress) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = inetAddress;
        this.remoteHost = inetAddress.getHostName();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String string) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = string;
        this.remoteAddr = InetAddress.getByName(string);
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.A;
    }

    public void setAutoPassiveIPSubstitution(boolean bl) {
        this.A = bl;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(bl);
        }
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String string) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = string;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener fTPMessageListener) {
        this.messageListener = fTPMessageListener;
        if (this.control != null) {
            this.control.A(fTPMessageListener);
        }
    }

    public void setConnectMode(FTPConnectMode fTPConnectMode) {
        this.N = fTPConnectMode;
    }

    public FTPConnectMode getConnectMode() {
        return this.N;
    }

    public void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor, long l2) {
        this.W = fTPProgressMonitor;
        this.F = l2;
    }

    public void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor) {
        this.W = fTPProgressMonitor;
    }

    public long getMonitorInterval() {
        return this.F;
    }

    public void setTransferBufferSize(int n2) {
        this.S = n2;
    }

    public int getTransferBufferSize() {
        return this.S;
    }

    public void cancelTransfer() {
        this.Y = true;
        G.warn("cancelTransfer() called");
    }

    public void setPORTIP(String string) throws FTPException {
        this.setActiveIPAddress(string);
    }

    public void setActiveIPAddress(String string) throws FTPException {
        this.checkConnection(true);
        this.control.A(string);
    }

    public void setActivePortRange(int n2, int n3) throws FTPException {
        this.checkConnection(true);
        if (n2 < 0 || n2 > n3 || n3 > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        this.control.setActivePortRange(n2, n3);
    }

    public void login(String string, String string2) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(string);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(string2);
    }

    public void login(String string, String string2, String string3) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(string);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(string2);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(string3);
        }
    }

    public void user(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("USER " + string);
        String[] stringArray = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void password(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("PASS " + string);
        String[] stringArray = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void account(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("ACCT " + string);
        String[] stringArray = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public static void initSOCKS(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put(H, string);
        properties.put(U, string2);
        System.setProperties(properties);
    }

    public static void initSOCKSAuthentication(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put("java.net.socks.username", string);
        properties.put("java.net.socks.password", string2);
        System.setProperties(properties);
    }

    public static void clearSOCKS() {
        Properties properties = System.getProperties();
        properties.remove(U);
        properties.remove(H);
        System.setProperties(properties);
    }

    String A() {
        return this.control.C();
    }

    public String quote(String string, String[] stringArray) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand(string);
        this.lastValidReply = stringArray != null ? this.control.validateReply(fTPReply, stringArray) : fTPReply;
        return this.lastValidReply.getReplyText();
    }

    public boolean exists(String string) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            FTPReply fTPReply = this.control.sendCommand("SIZE " + string);
            this.lastValidReply = this.control.validateReply(fTPReply, "213");
            return true;
        }
        catch (FTPException fTPException) {
            if (fTPException.getReplyCode() == 550) {
                return false;
            }
            try {
                FTPReply fTPReply = this.control.sendCommand("MDTM " + string);
                this.lastValidReply = this.control.validateReply(fTPReply, "213");
                return true;
            }
            catch (FTPException fTPException2) {
                if (fTPException.getReplyCode() == 550) {
                    return false;
                }
                throw new FTPException("Cannot determine if file '" + string + "' exists. Server does not support MDTM or SIZE command.");
            }
        }
    }

    public long size(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("SIZE " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, "213");
        String string2 = this.lastValidReply.getReplyText();
        int n2 = string2.indexOf(32);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FTPException("Failed to parse reply: " + string2);
        }
    }

    public void resume() throws FTPException {
        if (this.L.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.J = true;
    }

    public void cancelResume() throws IOException, FTPException {
        this.restart(0L);
        this.J = false;
    }

    public void restart(long l2) throws IOException, FTPException {
        FTPReply fTPReply = this.control.sendCommand("REST " + l2);
        this.lastValidReply = this.control.validateReply(fTPReply, "350");
    }

    public void put(String string, String string2) throws IOException, FTPException {
        this.put(string, string2, false);
    }

    public void put(InputStream inputStream, String string) throws IOException, FTPException {
        this.put(inputStream, string, false);
    }

    public void put(String string, String string2, boolean bl) throws IOException, FTPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.put(fileInputStream, string2, bl);
    }

    public void put(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.L;
        this.B(string);
        try {
            this.A(inputStream, string, bl);
            this.validateTransfer();
        }
        catch (IOException iOException) {
            this.B();
            throw iOException;
        }
        finally {
            this.L = fTPTransferType;
        }
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] stringArray = new String[]{"225", "226", "250", "426", "450"};
        FTPReply fTPReply = this.control.D();
        String string = fTPReply.getReplyCode();
        if ((string.equals("426") || string.equals("450")) && !this.Y) {
            throw new FTPException(fTPReply);
        }
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void B() throws IOException, FTPException {
        this.checkConnection(true);
        this.control.A(500);
        try {
            this.validateTransfer();
        }
        finally {
            this.control.A(this.timeout);
        }
    }

    private void C() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException iOException) {
                G.warn("Caught exception closing data socket", iOException);
            }
        }
    }

    private void A(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                G.warn("Caught exception closing data socket", iOException);
            }
        }
        this.C();
    }

    private void B(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                G.warn("Caught exception closing data socket", iOException);
            }
        }
        this.C();
    }

    private void A(String string, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        this.Y = false;
        boolean bl2 = false;
        this.data = null;
        try {
            this.data = this.control.A(this.N);
            this.data.setTimeout(this.timeout);
            if (this.J) {
                if (this.L.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                this.R = this.size(string);
                this.restart(this.R);
            }
            String string2 = bl ? "APPE " : "STOR ";
            FTPReply fTPReply = this.control.sendCommand(string2 + string);
            String[] stringArray = new String[]{"125", "150", "350"};
            this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        }
        catch (IOException iOException) {
            bl2 = true;
            throw iOException;
        }
        catch (FTPException fTPException) {
            bl2 = true;
            throw fTPException;
        }
        finally {
            if (bl2) {
                this.J = false;
                this.C();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        long l2 = 0L;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            this.A(string, bl);
            bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()), this.S * 2);
            if (this.J) {
                bufferedInputStream.skip(this.R);
            }
            byte[] byArray = new byte[this.S];
            byte[] byArray2 = null;
            long l3 = 0L;
            int n2 = 0;
            boolean bl2 = this.getType() == FTPTransferType.ASCII;
            int n3 = 0;
            while ((n2 = bufferedInputStream.read(byArray)) > 0 && !this.Y) {
                if (bl2) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        boolean bl3 = true;
                        int n4 = 0;
                        while (n3 < b.length && i2 + n3 < n2) {
                            if (byArray[i2 + n3] != b[n3]) {
                                bl3 = false;
                                break;
                            }
                            ++n4;
                            ++n3;
                        }
                        if (bl3) {
                            if (n3 == b.length) {
                                bufferedOutputStream.write(13);
                                bufferedOutputStream.write(10);
                                l2 += 2L;
                                l3 += 2L;
                                n3 = 0;
                                i2 += n4 - 1;
                                byArray2 = null;
                                continue;
                            }
                            byArray2 = new byte[n4];
                            for (int i3 = 0; i3 < n4; ++i3) {
                                byArray2[i3] = byArray[i2 + i3];
                            }
                            continue;
                        }
                        if (byArray2 != null) {
                            bufferedOutputStream.write(byArray2);
                            l2 += (long)byArray2.length;
                            l3 += (long)byArray2.length;
                            byArray2 = null;
                        }
                        bufferedOutputStream.write(byArray[i2]);
                        ++l2;
                        ++l3;
                        n3 = 0;
                    }
                } else {
                    bufferedOutputStream.write(byArray, 0, n2);
                    l2 += (long)n2;
                    l3 += (long)n2;
                }
                if (byArray2 != null) {
                    bufferedOutputStream.write(byArray2);
                    l2 += (long)byArray2.length;
                    l3 += (long)byArray2.length;
                }
                if (this.W == null || l3 <= this.F) continue;
                this.W.bytesTransferred(l2);
                l3 = 0L;
            }
            Object var20_17 = null;
            this.J = false;
        }
        catch (Throwable throwable) {
            Object var20_18 = null;
            this.J = false;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                G.warn("Caught exception closing input stream", iOException);
            }
            this.B(bufferedOutputStream);
            if (this.W != null) {
                this.W.bytesTransferred(l2);
            }
            G.debug("Transferred " + l2 + " bytes to remote host");
            throw throwable;
        }
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            G.warn("Caught exception closing input stream", iOException);
        }
        this.B(bufferedOutputStream);
        if (this.W != null) {
            this.W.bytesTransferred(l2);
        }
        G.debug("Transferred " + l2 + " bytes to remote host");
    }

    public void put(byte[] byArray, String string) throws IOException, FTPException {
        this.put(byArray, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] byArray, String string, boolean bl) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.L;
        this.B(string);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.put(byteArrayInputStream, string, bl);
        }
        finally {
            this.L = fTPTransferType;
        }
    }

    public void get(String string, String string2) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.L;
        this.B(string2);
        try {
            this.A(string, string2);
            this.validateTransfer();
        }
        catch (IOException iOException) {
            this.B();
            throw iOException;
        }
        finally {
            this.L = fTPTransferType;
        }
    }

    public void get(OutputStream outputStream, String string) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.L;
        this.B(string);
        try {
            this.A(outputStream, string);
            this.validateTransfer();
        }
        catch (IOException iOException) {
            this.B();
            throw iOException;
        }
        finally {
            this.L = fTPTransferType;
        }
    }

    private void A(String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.Y = false;
        boolean bl = false;
        this.data = null;
        try {
            this.data = this.control.A(this.N);
            this.data.setTimeout(this.timeout);
            if (this.J) {
                if (this.L.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                this.restart(this.R);
            }
            FTPReply fTPReply = this.control.sendCommand("RETR " + string);
            String[] stringArray = new String[]{"125", "150"};
            this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        catch (FTPException fTPException) {
            bl = true;
            throw fTPException;
        }
        finally {
            if (bl) {
                this.J = false;
                this.C();
            }
        }
    }

    private void A(String string, String string2) throws IOException, FTPException {
        File file = new File(string);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new FTPException(string + " is readonly - cannot write");
            }
            if (this.J) {
                this.R = file.length();
            }
        }
        this.A(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(string, this.J);
        try {
            this.A(fileOutputStream);
        }
        catch (IOException iOException) {
            file.delete();
            G.debug("Deleting local file '" + file.getAbsolutePath() + "'");
            throw iOException;
        }
    }

    private void A(OutputStream outputStream, String string) throws IOException, FTPException {
        this.A(string);
        this.A(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void A(OutputStream outputStream) throws IOException, FTPException {
        block26: {
            IOException iOException;
            long l2;
            BufferedInputStream bufferedInputStream;
            BufferedOutputStream bufferedOutputStream;
            block24: {
                int n2;
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                bufferedInputStream = null;
                l2 = 0L;
                iOException = null;
                bufferedInputStream = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
                this.data.setTimeout(this.timeout);
                long l3 = 0L;
                byte[] byArray = new byte[this.S];
                boolean bl = this.getType() == FTPTransferType.ASCII;
                boolean bl2 = false;
                while ((n2 = this.readChunk(bufferedInputStream, byArray, this.S)) >= 0 && !this.Y) {
                    if (bl) {
                        boolean bl3 = false;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            boolean bl4 = bl3 = byArray[i2] == 10;
                            if (bl2) {
                                if (bl3) {
                                    bufferedOutputStream.write(b, 0, b.length);
                                    l2 += (long)b.length;
                                    l3 += (long)b.length;
                                } else {
                                    bufferedOutputStream.write(13);
                                    ++l2;
                                    ++l3;
                                }
                            }
                            boolean bl5 = bl2 = byArray[i2] == 13;
                            if (bl3 || bl2) continue;
                            bufferedOutputStream.write(byArray[i2]);
                            ++l2;
                            ++l3;
                        }
                    } else {
                        bufferedOutputStream.write(byArray, 0, n2);
                        l2 += (long)n2;
                        l3 += (long)n2;
                    }
                    if (this.W == null || l3 <= this.F) continue;
                    this.W.bytesTransferred(l2);
                    l3 = 0L;
                }
                if (!bl || !bl2) break block24;
                bufferedOutputStream.write(13);
                ++l2;
                ++l3;
            }
            Object var16_14 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                G.warn("Caught exception closing output stream", iOException2);
            }
            this.J = false;
            this.A(bufferedInputStream);
            if (iOException != null) {
                throw iOException;
            }
            if (this.W != null) {
                this.W.bytesTransferred(l2);
            }
            G.debug("Transferred " + l2 + " bytes from remote host");
            {
                break block26;
                catch (IOException iOException3) {
                    iOException = iOException3;
                    Object var16_15 = null;
                    try {
                        if (bufferedOutputStream != null) {
                            bufferedOutputStream.close();
                        }
                    }
                    catch (IOException iOException4) {
                        G.warn("Caught exception closing output stream", iOException4);
                    }
                    this.J = false;
                    this.A(bufferedInputStream);
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (this.W != null) {
                        this.W.bytesTransferred(l2);
                    }
                    G.debug("Transferred " + l2 + " bytes from remote host");
                }
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                try {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    G.warn("Caught exception closing output stream", iOException5);
                }
                this.J = false;
                this.A(bufferedInputStream);
                if (iOException != null) {
                    throw iOException;
                }
                if (this.W != null) {
                    this.W.bytesTransferred(l2);
                }
                G.debug("Transferred " + l2 + " bytes from remote host");
                throw throwable;
            }
        }
    }

    public byte[] get(String string) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.L;
        this.B(string);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.S);
            this.A(byteArrayOutputStream, string);
            this.validateTransfer();
            byte[] byArray = byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            this.B();
            throw iOException;
        }
        finally {
            this.L = fTPTransferType;
        }
    }

    public boolean site(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("SITE " + string);
        String[] stringArray = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        return fTPReply.getReplyCode().equals("200");
    }

    public String list(String string) throws IOException, FTPException {
        return this.list(string, false);
    }

    public String list(String string, boolean bl) throws IOException, FTPException {
        String[] stringArray = this.dir(string, bl);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fTPFileFactory) {
        this.X = fTPFileFactory;
    }

    public void setParserLocale(Locale locale) {
        this.E = locale;
    }

    public FTPFile[] dirDetails(String string) throws IOException, FTPException, ParseException {
        if (this.X == null) {
            this.X = new FTPFileFactory(this.system());
        }
        this.X.setLocale(this.E);
        return this.X.parse(this.dir(string, true));
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String string) throws IOException, FTPException {
        return this.dir(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dir(String string, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            Object object;
            String string2;
            this.data = this.control.A(this.N);
            this.data.setTimeout(this.timeout);
            String string3 = string2 = bl ? "LIST " : "NLST ";
            if (string != null) {
                string2 = string2 + string;
            }
            string2 = string2.trim();
            FTPReply fTPReply = this.control.sendCommand(string2);
            String[] stringArray = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
            Object[] objectArray = new String[]{};
            String string4 = this.lastValidReply.getReplyCode();
            if (!(string4.equals("450") || string4.equals("550") || string4.equals("226"))) {
                String[] stringArray2;
                Vector<String[]> vector;
                block16: {
                    object = null;
                    vector = new Vector<String[]>();
                    try {
                        object = new LineNumberReader(new InputStreamReader(this.data.getInputStream(), this.controlEncoding));
                        stringArray2 = null;
                        while ((stringArray2 = this.readLine((LineNumberReader)object)) != null) {
                            vector.addElement(stringArray2);
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        try {
                            if (object != null) {
                                ((BufferedReader)object).close();
                            }
                        }
                        catch (IOException iOException) {
                            G.error("Failed to close socket in dir()", iOException);
                        }
                        this.C();
                        throw throwable;
                    }
                    try {
                        if (object != null) {
                            ((BufferedReader)object).close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {
                        G.error("Failed to close socket in dir()", iOException);
                    }
                    {
                    }
                }
                this.C();
                stringArray2 = new String[]{"226", "250"};
                fTPReply = this.control.D();
                this.lastValidReply = this.control.validateReply(fTPReply, stringArray2);
                if (!vector.isEmpty()) {
                    objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                }
            } else {
                object = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.C((String)object) && ((String)object).indexOf(T) < 0) {
                    throw new FTPException(fTPReply);
                }
            }
            object = objectArray;
            return object;
        }
        finally {
            this.C();
        }
    }

    private boolean C(String string) {
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (string.toUpperCase().indexOf(a[i2]) < 0) continue;
            return true;
        }
        return false;
    }

    protected int readChunk(BufferedInputStream bufferedInputStream, byte[] byArray, int n2) throws IOException {
        return bufferedInputStream.read(byArray, 0, n2);
    }

    protected int readChar(LineNumberReader lineNumberReader) throws IOException {
        return lineNumberReader.read();
    }

    protected String readLine(LineNumberReader lineNumberReader) throws IOException {
        return lineNumberReader.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPTransferType getType() {
        return this.L;
    }

    public void setType(FTPTransferType fTPTransferType) throws IOException, FTPException {
        this.checkConnection(true);
        String string = FTPTransferType.B;
        if (fTPTransferType.equals(FTPTransferType.BINARY)) {
            string = FTPTransferType.A;
        }
        FTPReply fTPReply = this.control.sendCommand("TYPE " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, "200");
        this.L = fTPTransferType;
    }

    public void delete(String string) throws IOException, FTPException {
        this.checkConnection(true);
        String[] stringArray = new String[]{"200", "250"};
        FTPReply fTPReply = this.control.sendCommand("DELE " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void rename(String string, String string2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("RNFR " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, "350");
        fTPReply = this.control.sendCommand("RNTO " + string2);
        this.lastValidReply = this.control.validateReply(fTPReply, "250");
    }

    public void rmdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("RMD " + string);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void mkdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("MKD " + string);
        String[] stringArray = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public void chdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("CWD " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, "250");
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("CDUP");
        String[] stringArray = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    public Date modtime(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("MDTM " + string);
        this.lastValidReply = this.control.validateReply(fTPReply, "213");
        Date date = this.O.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return date;
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(fTPReply, "257");
        String string = this.lastValidReply.getReplyText();
        int n2 = string.indexOf(34);
        int n3 = string.lastIndexOf(34);
        if (n2 >= 0 && n3 > n2) {
            return string.substring(n2 + 1, n3);
        }
        return string;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("FEAT");
        String[] stringArray = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            return this.lastValidReply.getReplyData();
        }
        throw new FTPException(fTPReply);
    }

    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("SYST");
        String[] stringArray = new String[]{"200", "213", "215"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("NOOP");
        this.lastValidReply = this.control.validateReply(fTPReply, "200");
    }

    public String help(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("HELP " + string);
        String[] stringArray = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply fTPReply = this.control.sendCommand("ABOR");
        String[] stringArray = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        try {
            FTPReply fTPReply = this.control.sendCommand("QUIT");
            String[] stringArray = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(fTPReply, stringArray);
        }
        finally {
            this.control.logout();
            this.control = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

