/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import xjava.security.interfaces.RSAFactors;
import xjava.security.interfaces.RSAKey;

public abstract class Any_RSA_PKCS1Signature
extends Signature {
    private static final boolean A = Debug.GLOBAL_DEBUG;
    private static final int E = A ? Debug.getLevel("RSA", "Any_RSA_PKCS1Signature") : 0;
    private BigInteger H;
    private BigInteger G;
    private BigInteger F;
    private BigInteger D;
    private BigInteger B;
    private MessageDigest C;

    private static void A(String string) {
        Debug.log("Any_RSA_PKCS1Signature: " + string);
    }

    protected Any_RSA_PKCS1Signature(String string) {
        super(string + "/RSA/PKCS#1");
        try {
            this.C = MessageDigest.getInstance(string, "CryptixEDT");
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception);
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Object object;
        if (privateKey instanceof RSAPrivateKey) {
            object = (RSAPrivateKey)privateKey;
            this.H = object.getModulus();
            this.G = object.getPrivateExponent();
        } else if (privateKey instanceof RSAKey) {
            object = (RSAKey)((Object)privateKey);
            this.H = object.getModulus();
            this.G = object.getExponent();
        } else {
            throw new InvalidKeyException(this.getAlgorithm() + ": " + privateKey.getClass().getName() + " is not an RSA private key - ");
        }
        if (privateKey instanceof RSAFactors) {
            object = (RSAFactors)((Object)privateKey);
            this.F = object.getP();
            this.D = object.getQ();
            this.B = object.getInverseOfQModP();
        }
        this.C.reset();
        int n2 = this.C.digest().length;
        int n3 = (this.H.bitLength() + 7) / 8;
        int n4 = this.getAlgorithmEncoding().length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Object object;
        if (publicKey instanceof RSAPublicKey) {
            object = (RSAPublicKey)publicKey;
            this.H = object.getModulus();
            this.G = object.getPublicExponent();
        } else if (publicKey instanceof RSAKey) {
            object = (RSAKey)((Object)publicKey);
            this.H = object.getModulus();
            this.G = object.getExponent();
        } else {
            throw new InvalidKeyException(this.getAlgorithm() + ": " + publicKey.getClass().getName() + " is not an RSA public key - ");
        }
        if (publicKey instanceof RSAFactors) {
            object = (RSAFactors)((Object)publicKey);
            this.F = object.getP();
            this.D = object.getQ();
            this.B = object.getInverseOfQModP();
        }
        this.C.reset();
        int n2 = this.C.digest().length;
        int n3 = (this.H.bitLength() + 7) / 8;
        int n4 = this.getAlgorithmEncoding().length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.C.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.C.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for signing");
        }
        long l2 = 0L;
        if (A && E >= 7) {
            l2 = System.currentTimeMillis();
        }
        BigInteger bigInteger = this.A();
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.H, this.G, this.F, this.D, this.B);
        if (A && E >= 7) {
            l2 = System.currentTimeMillis() - l2;
            Any_RSA_PKCS1Signature.A(" ...engineSign() completed in " + l2 + " ms.");
        }
        return bigInteger2.toByteArray();
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for verification");
        }
        long l2 = 0L;
        if (A && E >= 7) {
            l2 = System.currentTimeMillis();
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.H, this.G, this.F, this.D, this.B);
        BigInteger bigInteger3 = this.A();
        boolean bl = bigInteger2.equals(bigInteger3);
        if (A && E >= 7) {
            l2 = System.currentTimeMillis() - l2;
            Any_RSA_PKCS1Signature.A(" ...engineVerify() completed in " + l2 + " ms.");
            if (!bl) {
                Any_RSA_PKCS1Signature.A("   Computed: " + Hex.dumpString(bigInteger2.toByteArray()));
                Any_RSA_PKCS1Signature.A("     Actual: " + Hex.dumpString(bigInteger3.toByteArray()));
            }
        }
        return bl;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + string);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + string);
    }

    private BigInteger A() throws SignatureException {
        byte[] byArray = this.C.digest();
        int n2 = byArray.length;
        int n3 = (this.H.bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n3];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n4 = byArray3.length;
        int n5 = n3 - 3 - n4 - n2;
        if (n5 < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int n6 = 0;
        while (n6 < n5) {
            byArray2[2 + n6++] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n5 + 3, n4);
        System.arraycopy(byArray, 0, byArray2, n3 - n2, n2);
        if (A && E >= 4) {
            Any_RSA_PKCS1Signature.A("PKCS#1 frame = " + Hex.dumpString(byArray2));
        }
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();
}

