/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.A;

public class SHA256
extends A
implements Cloneable {
    private static final int g = 32;
    private static final int[] e = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private final int[] f;
    private final int[] d;

    public SHA256() {
        super("SHA-256", 32, 1);
        this.f = new int[8];
        this.d = new int[64];
        this.coreReset();
    }

    private SHA256(SHA256 sHA256) {
        super(sHA256.getAlgorithm(), sHA256);
        this.f = (int[])sHA256.f.clone();
        this.d = (int[])sHA256.d.clone();
    }

    public Object clone() {
        return new SHA256(this);
    }

    protected void coreDigest(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray[n2 + (i2 * 4 + (3 - i3))] = (byte)(this.f[i2] >>> 8 * i3);
            }
        }
    }

    protected void coreReset() {
        this.f[0] = 1779033703;
        this.f[1] = -1150833019;
        this.f[2] = 1013904242;
        this.f[3] = -1521486534;
        this.f[4] = 1359893119;
        this.f[5] = -1694144372;
        this.f[6] = 528734635;
        this.f[7] = 1541459225;
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int n3;
        int[] nArray = this.d;
        for (n3 = 0; n3 < 16; ++n3) {
            nArray[n3] = byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
        for (n3 = 16; n3 < 64; ++n3) {
            nArray[n3] = this.C(nArray[n3 - 2]) + nArray[n3 - 7] + this.D(nArray[n3 - 15]) + nArray[n3 - 16];
        }
        n3 = this.f[0];
        int n4 = this.f[1];
        int n5 = this.f[2];
        int n6 = this.f[3];
        int n7 = this.f[4];
        int n8 = this.f[5];
        int n9 = this.f[6];
        int n10 = this.f[7];
        for (int i2 = 0; i2 < 64; ++i2) {
            int n11 = n10 + this.A(n7) + this.E(n7, n8, n9) + e[i2] + nArray[i2];
            int n12 = this.B(n3) + this.F(n3, n4, n5);
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6 + n11;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n11 + n12;
        }
        this.f[0] = this.f[0] + n3;
        this.f[1] = this.f[1] + n4;
        this.f[2] = this.f[2] + n5;
        this.f[3] = this.f[3] + n6;
        this.f[4] = this.f[4] + n7;
        this.f[5] = this.f[5] + n8;
        this.f[6] = this.f[6] + n9;
        this.f[7] = this.f[7] + n10;
    }

    private final int E(int n2, int n3, int n4) {
        return n2 & n3 ^ ~n2 & n4;
    }

    private final int F(int n2, int n3, int n4) {
        return n2 & n3 ^ n2 & n4 ^ n3 & n4;
    }

    private final int B(int n2) {
        return this.B(2, n2) ^ this.B(13, n2) ^ this.B(22, n2);
    }

    private final int A(int n2) {
        return this.B(6, n2) ^ this.B(11, n2) ^ this.B(25, n2);
    }

    private final int D(int n2) {
        return this.B(7, n2) ^ this.B(18, n2) ^ this.A(3, n2);
    }

    private final int C(int n2) {
        return this.B(17, n2) ^ this.B(19, n2) ^ this.A(10, n2);
    }

    private final int A(int n2, int n3) {
        return n3 >>> n2;
    }

    private final int B(int n2, int n3) {
        return n3 >>> n2 | n3 << 32 - n2;
    }
}

