/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.A;

public final class RIPEMD160
extends A
implements Cloneable {
    private static final int[] T = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final int[] U = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final int[] S = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final int[] W = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};
    private static final int V = 20;
    private int[] R = new int[5];
    private int[] X = new int[16];

    public RIPEMD160() {
        super("RIPEMD160", 20, 0);
        this.coreReset();
    }

    private RIPEMD160(RIPEMD160 rIPEMD160) {
        super(rIPEMD160.getAlgorithm(), rIPEMD160);
        this.R = (int[])rIPEMD160.R.clone();
        this.X = (int[])rIPEMD160.X.clone();
    }

    public Object clone() {
        return new RIPEMD160(this);
    }

    protected void coreDigest(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray[n2 + (i2 * 4 + i3)] = (byte)(this.R[i2] >>> 8 * i3 & 0xFF);
            }
        }
    }

    protected void coreReset() {
        this.R[0] = 1732584193;
        this.R[1] = -271733879;
        this.R[2] = -1732584194;
        this.R[3] = 271733878;
        this.R[4] = -1009589776;
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 0; n10 < 16; ++n10) {
            this.X[n10] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
        int n11 = n9 = this.R[0];
        int n12 = n8 = this.R[1];
        int n13 = n7 = this.R[2];
        int n14 = n6 = this.R[3];
        int n15 = n5 = this.R[4];
        for (n10 = 0; n10 < 16; ++n10) {
            n4 = S[n10];
            n3 = n11 + (n12 ^ n13 ^ n14) + this.X[n10];
            n11 = n15;
            n15 = n14;
            n14 = n13 << 10 | n13 >>> 22;
            n13 = n12;
            n12 = (n3 << n4 | n3 >>> 32 - n4) + n11;
            n4 = W[n10];
            n3 = n9 + (n8 ^ (n7 | ~n6)) + this.X[U[n10]] + 1352829926;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = (n3 << n4 | n3 >>> 32 - n4) + n9;
        }
        for (n10 = 16; n10 < 32; ++n10) {
            n4 = S[n10];
            n3 = n11 + (n12 & n13 | ~n12 & n14) + this.X[T[n10]] + 1518500249;
            n11 = n15;
            n15 = n14;
            n14 = n13 << 10 | n13 >>> 22;
            n13 = n12;
            n12 = (n3 << n4 | n3 >>> 32 - n4) + n11;
            n4 = W[n10];
            n3 = n9 + (n8 & n6 | n7 & ~n6) + this.X[U[n10]] + 1548603684;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = (n3 << n4 | n3 >>> 32 - n4) + n9;
        }
        for (n10 = 32; n10 < 48; ++n10) {
            n4 = S[n10];
            n3 = n11 + ((n12 | ~n13) ^ n14) + this.X[T[n10]] + 1859775393;
            n11 = n15;
            n15 = n14;
            n14 = n13 << 10 | n13 >>> 22;
            n13 = n12;
            n12 = (n3 << n4 | n3 >>> 32 - n4) + n11;
            n4 = W[n10];
            n3 = n9 + ((n8 | ~n7) ^ n6) + this.X[U[n10]] + 1836072691;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = (n3 << n4 | n3 >>> 32 - n4) + n9;
        }
        for (n10 = 48; n10 < 64; ++n10) {
            n4 = S[n10];
            n3 = n11 + (n12 & n14 | n13 & ~n14) + this.X[T[n10]] + -1894007588;
            n11 = n15;
            n15 = n14;
            n14 = n13 << 10 | n13 >>> 22;
            n13 = n12;
            n12 = (n3 << n4 | n3 >>> 32 - n4) + n11;
            n4 = W[n10];
            n3 = n9 + (n8 & n7 | ~n8 & n6) + this.X[U[n10]] + 2053994217;
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = (n3 << n4 | n3 >>> 32 - n4) + n9;
        }
        for (n10 = 64; n10 < 80; ++n10) {
            n4 = S[n10];
            n3 = n11 + (n12 ^ (n13 | ~n14)) + this.X[T[n10]] + -1454113458;
            n11 = n15;
            n15 = n14;
            n14 = n13 << 10 | n13 >>> 22;
            n13 = n12;
            n12 = (n3 << n4 | n3 >>> 32 - n4) + n11;
            n4 = W[n10];
            n3 = n9 + (n8 ^ n7 ^ n6) + this.X[U[n10]];
            n9 = n5;
            n5 = n6;
            n6 = n7 << 10 | n7 >>> 22;
            n7 = n8;
            n8 = (n3 << n4 | n3 >>> 32 - n4) + n9;
        }
        n3 = this.R[1] + n13 + n6;
        this.R[1] = this.R[2] + n14 + n5;
        this.R[2] = this.R[3] + n15 + n9;
        this.R[3] = this.R[4] + n11 + n8;
        this.R[4] = this.R[0] + n12 + n7;
        this.R[0] = n3;
    }
}

