/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.A;

public final class RIPEMD
extends A {
    private static final int P = 16;
    private int[] N = new int[4];
    private int[] O = new int[4];
    private int[] Q = new int[16];

    public RIPEMD() {
        super("RIPEMD", 16, 0);
        this.coreReset();
    }

    private RIPEMD(RIPEMD rIPEMD) {
        super(rIPEMD.getAlgorithm(), rIPEMD);
        this.N = (int[])rIPEMD.N.clone();
        this.O = (int[])rIPEMD.O.clone();
        this.Q = (int[])rIPEMD.Q.clone();
    }

    public Object clone() {
        return new RIPEMD(this);
    }

    protected void coreDigest(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray[n2 + (i2 * 4 + i3)] = (byte)(this.N[i2] >>> 8 * i3);
            }
        }
    }

    protected void coreReset() {
        this.N[0] = 1732584193;
        this.N[1] = -271733879;
        this.N[2] = -1732584194;
        this.N[3] = 271733878;
    }

    protected void coreUpdate(byte[] byArray, int n2) {
        int n3;
        for (n3 = 0; n3 < 16; ++n3) {
            this.Q[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
        n3 = this.N[0];
        int n4 = this.N[1];
        int n5 = this.N[2];
        int n6 = this.N[3];
        n3 = this.B(n3, n4, n5, n6, this.Q[0], 11);
        n6 = this.B(n6, n3, n4, n5, this.Q[1], 14);
        n5 = this.B(n5, n6, n3, n4, this.Q[2], 15);
        n4 = this.B(n4, n5, n6, n3, this.Q[3], 12);
        n3 = this.B(n3, n4, n5, n6, this.Q[4], 5);
        n6 = this.B(n6, n3, n4, n5, this.Q[5], 8);
        n5 = this.B(n5, n6, n3, n4, this.Q[6], 7);
        n4 = this.B(n4, n5, n6, n3, this.Q[7], 9);
        n3 = this.B(n3, n4, n5, n6, this.Q[8], 11);
        n6 = this.B(n6, n3, n4, n5, this.Q[9], 13);
        n5 = this.B(n5, n6, n3, n4, this.Q[10], 14);
        n4 = this.B(n4, n5, n6, n3, this.Q[11], 15);
        n3 = this.B(n3, n4, n5, n6, this.Q[12], 6);
        n6 = this.B(n6, n3, n4, n5, this.Q[13], 7);
        n5 = this.B(n5, n6, n3, n4, this.Q[14], 9);
        n4 = this.B(n4, n5, n6, n3, this.Q[15], 8);
        n3 = this.C(n3, n4, n5, n6, this.Q[7], 7);
        n6 = this.C(n6, n3, n4, n5, this.Q[4], 6);
        n5 = this.C(n5, n6, n3, n4, this.Q[13], 8);
        n4 = this.C(n4, n5, n6, n3, this.Q[1], 13);
        n3 = this.C(n3, n4, n5, n6, this.Q[10], 11);
        n6 = this.C(n6, n3, n4, n5, this.Q[6], 9);
        n5 = this.C(n5, n6, n3, n4, this.Q[15], 7);
        n4 = this.C(n4, n5, n6, n3, this.Q[3], 15);
        n3 = this.C(n3, n4, n5, n6, this.Q[12], 7);
        n6 = this.C(n6, n3, n4, n5, this.Q[0], 12);
        n5 = this.C(n5, n6, n3, n4, this.Q[9], 15);
        n4 = this.C(n4, n5, n6, n3, this.Q[5], 9);
        n3 = this.C(n3, n4, n5, n6, this.Q[14], 7);
        n6 = this.C(n6, n3, n4, n5, this.Q[2], 11);
        n5 = this.C(n5, n6, n3, n4, this.Q[11], 13);
        n4 = this.C(n4, n5, n6, n3, this.Q[8], 12);
        n3 = this.E(n3, n4, n5, n6, this.Q[3], 11);
        n6 = this.E(n6, n3, n4, n5, this.Q[10], 13);
        n5 = this.E(n5, n6, n3, n4, this.Q[2], 14);
        n4 = this.E(n4, n5, n6, n3, this.Q[4], 7);
        n3 = this.E(n3, n4, n5, n6, this.Q[9], 14);
        n6 = this.E(n6, n3, n4, n5, this.Q[15], 9);
        n5 = this.E(n5, n6, n3, n4, this.Q[8], 13);
        n4 = this.E(n4, n5, n6, n3, this.Q[1], 15);
        n3 = this.E(n3, n4, n5, n6, this.Q[14], 6);
        n6 = this.E(n6, n3, n4, n5, this.Q[7], 8);
        n5 = this.E(n5, n6, n3, n4, this.Q[0], 13);
        n4 = this.E(n4, n5, n6, n3, this.Q[6], 6);
        n3 = this.E(n3, n4, n5, n6, this.Q[11], 12);
        n6 = this.E(n6, n3, n4, n5, this.Q[13], 5);
        n5 = this.E(n5, n6, n3, n4, this.Q[5], 7);
        n4 = this.E(n4, n5, n6, n3, this.Q[12], 5);
        this.O[0] = n3;
        this.O[1] = n4;
        this.O[2] = n5;
        this.O[3] = n6;
        n3 = this.N[0];
        n4 = this.N[1];
        n5 = this.N[2];
        n6 = this.N[3];
        n3 = this.D(n3, n4, n5, n6, this.Q[0], 11);
        n6 = this.D(n6, n3, n4, n5, this.Q[1], 14);
        n5 = this.D(n5, n6, n3, n4, this.Q[2], 15);
        n4 = this.D(n4, n5, n6, n3, this.Q[3], 12);
        n3 = this.D(n3, n4, n5, n6, this.Q[4], 5);
        n6 = this.D(n6, n3, n4, n5, this.Q[5], 8);
        n5 = this.D(n5, n6, n3, n4, this.Q[6], 7);
        n4 = this.D(n4, n5, n6, n3, this.Q[7], 9);
        n3 = this.D(n3, n4, n5, n6, this.Q[8], 11);
        n6 = this.D(n6, n3, n4, n5, this.Q[9], 13);
        n5 = this.D(n5, n6, n3, n4, this.Q[10], 14);
        n4 = this.D(n4, n5, n6, n3, this.Q[11], 15);
        n3 = this.D(n3, n4, n5, n6, this.Q[12], 6);
        n6 = this.D(n6, n3, n4, n5, this.Q[13], 7);
        n5 = this.D(n5, n6, n3, n4, this.Q[14], 9);
        n4 = this.D(n4, n5, n6, n3, this.Q[15], 8);
        n3 = this.A(n3, n4, n5, n6, this.Q[7], 7);
        n6 = this.A(n6, n3, n4, n5, this.Q[4], 6);
        n5 = this.A(n5, n6, n3, n4, this.Q[13], 8);
        n4 = this.A(n4, n5, n6, n3, this.Q[1], 13);
        n3 = this.A(n3, n4, n5, n6, this.Q[10], 11);
        n6 = this.A(n6, n3, n4, n5, this.Q[6], 9);
        n5 = this.A(n5, n6, n3, n4, this.Q[15], 7);
        n4 = this.A(n4, n5, n6, n3, this.Q[3], 15);
        n3 = this.A(n3, n4, n5, n6, this.Q[12], 7);
        n6 = this.A(n6, n3, n4, n5, this.Q[0], 12);
        n5 = this.A(n5, n6, n3, n4, this.Q[9], 15);
        n4 = this.A(n4, n5, n6, n3, this.Q[5], 9);
        n3 = this.A(n3, n4, n5, n6, this.Q[14], 7);
        n6 = this.A(n6, n3, n4, n5, this.Q[2], 11);
        n5 = this.A(n5, n6, n3, n4, this.Q[11], 13);
        n4 = this.A(n4, n5, n6, n3, this.Q[8], 12);
        n3 = this.F(n3, n4, n5, n6, this.Q[3], 11);
        n6 = this.F(n6, n3, n4, n5, this.Q[10], 13);
        n5 = this.F(n5, n6, n3, n4, this.Q[2], 14);
        n4 = this.F(n4, n5, n6, n3, this.Q[4], 7);
        n3 = this.F(n3, n4, n5, n6, this.Q[9], 14);
        n6 = this.F(n6, n3, n4, n5, this.Q[15], 9);
        n5 = this.F(n5, n6, n3, n4, this.Q[8], 13);
        n4 = this.F(n4, n5, n6, n3, this.Q[1], 15);
        n3 = this.F(n3, n4, n5, n6, this.Q[14], 6);
        n6 = this.F(n6, n3, n4, n5, this.Q[7], 8);
        n5 = this.F(n5, n6, n3, n4, this.Q[0], 13);
        n4 = this.F(n4, n5, n6, n3, this.Q[6], 6);
        n3 = this.F(n3, n4, n5, n6, this.Q[11], 12);
        n6 = this.F(n6, n3, n4, n5, this.Q[13], 5);
        n5 = this.F(n5, n6, n3, n4, this.Q[5], 7);
        n4 = this.F(n4, n5, n6, n3, this.Q[12], 5);
        n3 += this.O[3];
        n4 += this.O[0];
        n5 += this.O[1];
        n6 += this.O[2];
        this.N[1] = n3 += this.N[2];
        this.N[2] = n4 += this.N[3];
        this.N[3] = n5 += this.N[0];
        this.N[0] = n6 += this.N[1];
    }

    private int B(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 & n4 | ~n3 & n5) + n6;
        return n8 << n7 | n8 >>> 32 - n7;
    }

    private int C(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 & (n4 | n5) | n4 & n5) + n6 + 1518500249;
        return n8 << n7 | n8 >>> 32 - n7;
    }

    private int E(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 ^ n4 ^ n5) + n6 + 1859775393;
        return n8 << n7 | n8 >>> 32 - n7;
    }

    private int D(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 & n4 | ~n3 & n5) + n6 + 1352829926;
        return n8 << n7 | n8 >>> 32 - n7;
    }

    private int A(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 & (n4 | n5) | n4 & n5) + n6;
        return n8 << n7 | n8 >>> 32 - n7;
    }

    private int F(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + (n3 ^ n4 ^ n5) + n6 + 1548603684;
        return n8 << n7 | n8 >>> 32 - n7;
    }
}

