/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.SecureRandom;
import xjava.security.ExtendedKeyGenerator;
import xjava.security.KeyGenerator;
import xjava.security.SecretKey;
import xjava.security.WeakKeyException;

public class RawKeyGenerator
extends KeyGenerator
implements ExtendedKeyGenerator,
Cloneable {
    private SecureRandom _;
    private int Y;
    private int a;
    private int X;
    private boolean Z;

    protected RawKeyGenerator(String string, int n2) throws IllegalArgumentException {
        super(string);
        if (n2 <= 0) {
            throw new IllegalArgumentException("seedlength <= 0");
        }
        this.Y = n2;
        this.a = n2;
        this.X = n2;
    }

    protected RawKeyGenerator(String string, int n2, int n3, int n4) throws IllegalArgumentException {
        super(string);
        if (0 >= n2 || n2 > n3 || n3 > n4) {
            throw new IllegalArgumentException("!(0 < minlength && minlength <= defaultlength && defaultlength <= maxlength)");
        }
        this.Y = n2;
        this.a = n3;
        this.X = n4;
    }

    public SecretKey generateKey() {
        if (this._ == null) {
            this._ = new SecureRandom();
        }
        byte[] byArray = new byte[this.a];
        while (true) {
            this._.nextBytes(byArray);
            try {
                byte[] byArray2 = this.engineGenerateKey(byArray);
                return new RawSecretKey(this.getAlgorithm(), byArray2);
            }
            catch (KeyException keyException) {
                continue;
            }
            break;
        }
    }

    public void initialize(SecureRandom secureRandom) {
        this._ = secureRandom;
    }

    public void initialize(SecureRandom secureRandom, int n2) {
        if (!this.isValidKeyLength(n2)) {
            throw new IllegalArgumentException("invalid key length for " + this.getAlgorithm() + ": " + n2 + " bytes");
        }
        this._ = secureRandom;
        this.a = n2;
    }

    public boolean isWeakAllowed() {
        return this.Z;
    }

    public void setWeakAllowed(boolean bl) {
        this.Z = bl;
    }

    public int getMinimumKeyLength() {
        return this.Y;
    }

    public int getDefaultKeyLength() {
        return this.a;
    }

    public int getMaximumKeyLength() {
        return this.X;
    }

    public boolean isValidKeyLength(int n2) {
        return n2 >= this.Y && n2 <= this.X;
    }

    public SecretKey generateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        if (!this.isValidKeyLength(byArray.length)) {
            throw new InvalidKeyException("invalid key length for " + this.getAlgorithm() + ": " + byArray.length + " bytes");
        }
        byte[] byArray2 = this.engineGenerateKey((byte[])byArray.clone());
        return new RawSecretKey(this.getAlgorithm(), byArray2);
    }

    protected byte[] engineGenerateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        if (!this.isWeakAllowed() && this.isWeak(byArray)) {
            throw new WeakKeyException(this.getAlgorithm());
        }
        return byArray;
    }

    protected boolean isWeak(byte[] byArray) {
        return false;
    }
}

