/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.provider.key.RawKeyGenerator;
import java.security.InvalidKeyException;
import xjava.security.WeakKeyException;

public class DESKeyGenerator
extends RawKeyGenerator {
    public DESKeyGenerator() {
        super("DES", 8);
    }

    protected DESKeyGenerator(String string, int n2) {
        super(string, n2);
    }

    protected byte[] engineGenerateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        byArray = super.engineGenerateKey(byArray);
        this.setParity(byArray);
        return byArray;
    }

    protected void setParity(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7) & 1);
        }
    }

    protected boolean isWeak(byte[] byArray) {
        return this.isWeak(byArray, 0);
    }

    protected boolean isWeak(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFE) << 8 | byArray[n2 + 1] & 0xFE;
        int n4 = (byArray[n2 + 2] & 0xFE) << 8 | byArray[n2 + 3] & 0xFE;
        int n5 = (byArray[n2 + 4] & 0xFE) << 8 | byArray[n2 + 5] & 0xFE;
        int n6 = (byArray[n2 + 6] & 0xFE) << 8 | byArray[n2 + 7] & 0xFE;
        return !(n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278 || n5 != 0 && n5 != 65278 || n6 != 0 && n6 != 65278);
    }
}

