/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.dsa;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class RawDSASignature
extends Signature {
    private BigInteger D;
    private BigInteger C;
    private BigInteger B;
    private BigInteger F;
    byte[] E = null;
    SecureRandom A;

    public RawDSASignature(String string) {
        super(string);
    }

    public RawDSASignature() {
        super("RawDSA");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Public Key");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.A(dSAPublicKey.getParams());
        this.F = dSAPublicKey.getY();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a DSA Private Key");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.A(dSAPrivateKey.getParams());
        this.F = dSAPrivateKey.getX();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a SHA-1 digest for input");
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.E != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA may only be updated once");
        }
        if (n3 != 20) {
            throw new SignatureException(this.getAlgorithm() + ": Raw DSA must have a 20 byte input");
        }
        this.E = new byte[20];
        System.arraycopy(byArray, n2, this.E, 0, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.E == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        if (this.A == null) {
            this.A = new SecureRandom();
        }
        BigInteger bigInteger = new BigInteger(180, this.A);
        BigInteger bigInteger2 = bigInteger.mod(this.C);
        BigInteger bigInteger3 = bigInteger2.modInverse(this.C);
        BigInteger bigInteger4 = this.B.modPow(bigInteger2, this.D).mod(this.C);
        BigInteger bigInteger5 = new BigInteger(1, this.E);
        BigInteger bigInteger6 = bigInteger5.add(this.F.multiply(bigInteger4));
        bigInteger6 = bigInteger6.multiply(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.mod(this.C);
        byte[] byArray = bigInteger4.toByteArray();
        byte[] byArray2 = bigInteger7.toByteArray();
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 6];
        byArray3[0] = 48;
        byArray3[1] = (byte)(byArray.length + byArray2.length + 4 & 0xFF);
        int n2 = 2;
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)(byArray.length & 0xFF);
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = 2;
        byArray3[n2++] = (byte)(byArray2.length & 0xFF);
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        return byArray3;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n2 = 0;
        int n3 = byArray.length;
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.E == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply digest");
        }
        BigInteger bigInteger = new BigInteger(1, this.E);
        this.A(byArray, n2++, 48, "Tag: expecting sequence");
        this.A(byArray, n2++, byArray.length - 2, "length");
        this.A(byArray, n2++, 2, "Tag: expecting integer");
        byte by = byArray[n2++];
        if (by > (n3 -= 4)) {
            throw new SignatureException("r longer than total encoding");
        }
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n2, byArray2, 0, by);
        n3 -= by;
        n2 += by;
        this.A(byArray, n2++, 2, "Tag: expecting integer");
        byte by2 = byArray[n2++];
        if (by2 != (n3 -= 2)) {
            throw new SignatureException("incorrect length for than total encoding");
        }
        byte[] byArray3 = new byte[by2];
        System.arraycopy(byArray, n2, byArray3, 0, by2);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        BigInteger bigInteger3 = new BigInteger(byArray3);
        BigInteger bigInteger4 = new BigInteger("0");
        if (bigInteger2.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger2.compareTo(this.C) >= 0) {
            return false;
        }
        if (bigInteger3.compareTo(bigInteger4) <= 0) {
            return false;
        }
        if (bigInteger3.compareTo(this.C) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modInverse(this.C);
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger5);
        BigInteger bigInteger7 = bigInteger6.mod(this.C);
        BigInteger bigInteger8 = bigInteger2.multiply(bigInteger5);
        BigInteger bigInteger9 = bigInteger8.mod(this.C);
        BigInteger bigInteger10 = this.B.modPow(bigInteger7, this.D);
        BigInteger bigInteger11 = this.F.modPow(bigInteger9, this.D);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.mod(this.D);
        BigInteger bigInteger14 = bigInteger13.mod(this.C);
        return bigInteger14.equals(bigInteger2);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (string.equals("SecureRandom")) {
            this.A = (SecureRandom)object;
            return;
        }
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    private void A(byte[] byArray, int n2, int n3, String string) throws SignatureException {
        if (byArray[n2] != n3) {
            throw new SignatureException(this.getAlgorithm() + ": Encoding error. Bad " + string);
        }
    }

    private void A(DSAParams dSAParams) {
        this.D = dSAParams.getP();
        this.C = dSAParams.getQ();
        this.B = dSAParams.getG();
    }
}

