/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.encoding;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNAny;
import com.enterprisedt.cryptix.asn1.lang.ASNBitString;
import com.enterprisedt.cryptix.asn1.lang.ASNBoolean;
import com.enterprisedt.cryptix.asn1.lang.ASNInteger;
import com.enterprisedt.cryptix.asn1.lang.ASNNull;
import com.enterprisedt.cryptix.asn1.lang.ASNObjectIdentifier;
import com.enterprisedt.cryptix.asn1.lang.ASNOctetString;
import com.enterprisedt.cryptix.asn1.lang.ASNPrintableString;
import com.enterprisedt.cryptix.asn1.lang.ASNSequence;
import com.enterprisedt.cryptix.asn1.lang.ASNSequenceOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSet;
import com.enterprisedt.cryptix.asn1.lang.ASNSetOf;
import com.enterprisedt.cryptix.asn1.lang.ASNTaggedType;
import com.enterprisedt.cryptix.asn1.lang.ASNTime;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.asn1.lang.SimpleNode;
import com.enterprisedt.cryptix.asn1.lang.Tag;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class DER
extends BaseCoder {
    private static final boolean D = Debug.GLOBAL_DEBUG;
    private static final int E = D ? Debug.getLevel("DER") : 0;

    public void encode(ASNBoolean aSNBoolean, OutputStream outputStream) throws IOException {
        boolean bl = (Boolean)aSNBoolean.getValue();
        outputStream.write(1);
        DER.A(1, outputStream);
        outputStream.write(bl ? 1 : 0);
    }

    public void encode(ASNOctetString aSNOctetString, OutputStream outputStream) throws IOException {
        byte[] byArray = (byte[])aSNOctetString.getValue();
        outputStream.write(4);
        DER.A(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public void encode(ASNNull aSNNull, OutputStream outputStream) throws IOException {
        outputStream.write(5);
        DER.A(0, outputStream);
    }

    public void encode(ASNObjectIdentifier aSNObjectIdentifier, OutputStream outputStream) throws IOException {
        String string = (String)aSNObjectIdentifier.getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        for (int i3 = 2; i3 < nArray.length; ++i3) {
            int n2;
            int n3 = nArray[i3];
            byte[] byArray = new byte[4];
            for (n2 = 0; n2 < 4; ++n2) {
                byArray[n2] = (byte)(n3 & 0x7F);
                if ((n3 >>>= 7) == 0) break;
            }
            while (n2 > 0) {
                byteArrayOutputStream.write(byArray[n2] | 0x80);
                --n2;
            }
            byteArrayOutputStream.write(byArray[0]);
        }
        outputStream.write(6);
        DER.A(byteArrayOutputStream.size(), outputStream);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public void encode(ASNSequence aSNSequence, OutputStream outputStream) throws IOException {
        aSNSequence.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream.write(16);
        DER.A(byteArrayOutputStream.size(), outputStream);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public void encode(ASNTaggedType aSNTaggedType, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNTime aSNTime, OutputStream outputStream) throws IOException {
    }

    public void decode(ASNBoolean aSNBoolean, InputStream inputStream) throws IOException {
        if (!this.A(1, inputStream)) {
            String string = "Not a BOOLEAN";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNBoolean.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            if (n2 != 1) {
                throw new IOException("Incorrect BOOLEAN length: " + n2);
            }
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new EOFException();
            }
            aSNBoolean.setValue(new Boolean(n3 != 0));
        }
    }

    public void decode(ASNInteger aSNInteger, InputStream inputStream) throws IOException {
        if (!this.A(2, inputStream)) {
            String string = "Not an INTEGER";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNInteger.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            aSNInteger.setValue(new BigInteger(1, byArray));
        }
    }

    public void decode(ASNBitString aSNBitString, InputStream inputStream) throws IOException {
        if (!this.A(3, inputStream)) {
            String string = "Not a BIT STRING";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNBitString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            aSNBitString.setValue(byArray);
            if (D && E > 8) {
                Debug.log("DER - OUT: " + Hex.toString(byArray));
            }
        }
    }

    public void decode(ASNOctetString aSNOctetString, InputStream inputStream) throws IOException {
        if (!this.A(4, inputStream)) {
            String string = "Not an OCTET STRING";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNOctetString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            aSNOctetString.setValue(byArray);
            if (D && E > 8) {
                Debug.log("DER - OUT: " + Hex.toString(byArray));
            }
        }
    }

    public void decode(ASNNull aSNNull, InputStream inputStream) throws IOException {
        if (!this.A(5, inputStream)) {
            String string = "Not a NULL";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNNull.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            if (n2 != 0) {
                throw new IOException("Incorrect NULL length: " + n2);
            }
        }
    }

    public void decode(ASNObjectIdentifier aSNObjectIdentifier, InputStream inputStream) throws IOException {
        if (!this.A(6, inputStream)) {
            String string = "Not an OBJECT-IDENTIFIER";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNObjectIdentifier.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2;
            int n3;
            int n4 = DER.A(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            if (--n4 >= 0) {
                n3 = inputStream.read() & 0xFF;
                n2 = n3 < 40 ? 0 : (n3 < 80 ? 1 : 2);
                int n5 = n3 - n2 * 40;
                stringBuffer.append(n2).append(".").append(n5);
            }
            while (n4 > 0) {
                stringBuffer.append(".");
                n3 = 0;
                do {
                    n2 = inputStream.read() & 0xFF;
                    n3 = n3 << 7 | n2 & 0x7F;
                } while (--n4 > 0 && (n2 & 0x80) == 128);
                stringBuffer.append(n3);
            }
            aSNObjectIdentifier.setValue(new String(stringBuffer));
        }
    }

    public void decode(ASNSequence aSNSequence, InputStream inputStream) throws IOException {
        this.B(aSNSequence, inputStream);
    }

    public void decode(ASNSequenceOf aSNSequenceOf, InputStream inputStream) throws IOException {
        this.B(aSNSequenceOf, inputStream);
    }

    public void decode(ASNSet aSNSet, InputStream inputStream) throws IOException {
        this.A(aSNSet, inputStream);
    }

    public void decode(ASNSetOf aSNSetOf, InputStream inputStream) throws IOException {
        this.A(aSNSetOf, inputStream);
    }

    public void decode(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        Tag tag = aSNTaggedType.getTag();
        inputStream.mark(10);
        if (this.A(tag, inputStream)) {
            if (tag.isExplicit()) {
                this.decodeExplicitTaggedType(aSNTaggedType, inputStream);
            } else {
                inputStream.reset();
                this.decodeImplicitTaggedType(aSNTaggedType, inputStream);
            }
        } else {
            Object object;
            String string = "Failed to read a non-optional element";
            if (D && E > 0) {
                Debug.log("DER - " + string);
            }
            if ((object = aSNTaggedType.getDefaultValue()) == null && !aSNTaggedType.isOptional()) {
                throw new IOException(string);
            }
            if (object != null) {
                aSNTaggedType.setValue(object);
            }
            inputStream.reset();
        }
    }

    public void decode(ASNAny aSNAny, InputStream inputStream) throws IOException {
        byte[] byArray = this.B(inputStream);
        if (byArray != null) {
            aSNAny.setValue(byArray);
        }
        if (D && E > 8) {
            Debug.log("DER - OUT: " + Hex.toString(byArray));
        }
    }

    public void decode(ASNPrintableString aSNPrintableString, InputStream inputStream) throws IOException {
        if (!this.A(19, inputStream) && !this.A(12, inputStream)) {
            String string = "Not a PrintableString or IA5String or UTF8String";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNPrintableString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            aSNPrintableString.setValue(new String(byArray, "ISO_8859-1"));
        }
    }

    public void decode(ASNTime aSNTime, InputStream inputStream) throws IOException {
        if (!this.A(23, inputStream)) {
            String string = "Not a UTC_TIME";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!aSNTime.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            int n4 = (byArray[0] - 48) * 10 + (byArray[1] - 48);
            int n5 = (byArray[2] - 48) * 10 + (byArray[3] - 48) - 1;
            int n6 = (byArray[4] - 48) * 10 + (byArray[5] - 48);
            int n7 = (byArray[6] - 48) * 10 + (byArray[7] - 48);
            int n8 = (byArray[8] - 48) * 10 + (byArray[9] - 48);
            int n9 = 0;
            n4 += n4 <= 50 ? 2000 : 1900;
            if (byArray[10] != 90) {
                n9 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
                if (byArray[12] != 90) {
                    throw new IOException("Bad date format");
                }
            }
            calendar.set(n4, n5, n6, n7, n8, n9);
            aSNTime.setValue(calendar.getTime());
        }
    }

    private boolean A(int n2, InputStream inputStream) throws IOException {
        Tag tag = Tag.getExpectedTag(n2, inputStream);
        return tag != null;
    }

    private boolean A(Tag tag, InputStream inputStream) throws IOException {
        Tag tag2 = Tag.getExpectedTag(tag, inputStream);
        return tag2 != null;
    }

    private static int A(InputStream inputStream) throws IOException {
        int n2;
        int n3 = inputStream.read();
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) > 4) {
                throw new IOException("ASN.1 DER object too large");
            }
            n2 = 0;
            while (n3-- > 0) {
                n2 = n2 << 8 | inputStream.read() & 0xFF;
            }
        }
        if (D && E > 7) {
            Debug.log("DER - Element length = " + n2);
        }
        return n2;
    }

    private void B(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.A(16, inputStream) && !this.A(48, inputStream)) {
            String string = "Not a SEQUENCE [OF]";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                if (object == null) continue;
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    private void A(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.A(17, inputStream) && !this.A(49, inputStream)) {
            String string = "Not a SET [OF]";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n2 = DER.A(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    public void decodeExplicitTaggedType(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        int n2 = DER.A(inputStream);
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray);
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n3 != n2) {
            throw new IOException("Length (" + n2 + ") mismatch: " + n3);
        }
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        coderOperations.init(new ByteArrayInputStream(byArray));
        SimpleNode simpleNode = (SimpleNode)Parser.resolve(aSNTaggedType.getName());
        Object object = simpleNode.childrenAccept(coderOperations, null);
        String string = "********************* New value: XXX";
        if (D && E > 0) {
            Debug.log("DER - " + string);
        }
        aSNTaggedType.setValue(object);
    }

    public boolean decodeImplicitTaggedType(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        byte[] byArray = Tag.getTag(inputStream);
        Tag tag = aSNTaggedType.getTag();
        if (tag.isExplicit()) {
            return false;
        }
        int n2 = DER.A(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (aSNTaggedType.jjtGetNumChildren() != 1) {
            String string = "Implicitly Tagged types must have exactly one child";
            if (D && E > 8) {
                Debug.log("DER - " + string);
            }
            throw new IOException(string);
        }
        Tag tag2 = aSNTaggedType.getChild(0).getTag();
        if (tag2 == null) {
            if (D && E > 0) {
                Debug.log("DER - ... decoding an IMPLICIT ANY, using original tag");
            }
            byteArrayOutputStream.write(byArray);
        } else {
            byteArrayOutputStream.write(tag2.getValue());
        }
        DER.A(n2, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[n2 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        int n3 = inputStream.read(byArray3, byArray2.length, n2);
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n3 != n2) {
            throw new IOException("Length (" + n2 + ") mismatch: " + n3);
        }
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        coderOperations.init(new ByteArrayInputStream(byArray3));
        Object object = aSNTaggedType.childrenAccept(coderOperations, null);
        aSNTaggedType.setValue(object);
        return true;
    }

    public void decode(InputStream inputStream, int n2) throws IOException {
        byte[] byArray;
        int n3;
        Tag tag;
        Vector<_A> vector = new Vector<_A>();
        while (inputStream.available() != 0) {
            try {
                tag = Tag.decode(inputStream);
                n3 = DER.A(inputStream);
                byArray = new byte[n3];
                inputStream.read(byArray);
                vector.addElement(new _A(tag, n3, byArray));
            }
            catch (EOFException eOFException) {
                Debug.log("DER - " + eOFException.toString());
                break;
            }
        }
        if (D && E > 8) {
            int n4;
            String string = "\t";
            for (n4 = 0; n4 < n2; ++n4) {
                string = string + "+--";
            }
            ++n2;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                _A _A2 = (_A)vector.elementAt(n4);
                tag = _A2.B();
                n3 = _A2.C();
                byArray = _A2.A();
                System.out.println(string + "Tag: " + tag + "; Length: " + n3);
                if (!tag.isConstructed()) continue;
                this.decode(new ByteArrayInputStream(byArray), n2);
            }
        }
    }

    private static void A(int n2, OutputStream outputStream) throws IOException {
        if (n2 < 128) {
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 256) {
            outputStream.write(-127);
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 65536) {
            outputStream.write(-126);
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            return;
        }
        if (n2 < 0x1000000) {
            outputStream.write(-125);
            outputStream.write((byte)(n2 >> 16));
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            return;
        }
        outputStream.write(-124);
        outputStream.write((byte)(n2 >> 24));
        outputStream.write((byte)(n2 >> 16));
        outputStream.write((byte)(n2 >> 8));
        outputStream.write((byte)n2);
    }

    private byte[] B(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = Tag.getTag(inputStream);
        if (byArray == null) {
            return null;
        }
        if (D && E > 0) {
            Debug.log("DER - Tag: " + Hex.toString(byArray));
        }
        int n2 = DER.A(inputStream);
        byteArrayOutputStream.write(byArray);
        DER.A(n2, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[byArray2.length + n2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        if (n2 > 0) {
            int n3 = inputStream.read(byArray3, byArray2.length, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            if (n3 != n2) {
                throw new IOException("Length (" + n2 + ") mismatch: " + n3);
            }
        }
        return byArray3;
    }

    class _A {
        Tag A;
        int B;
        byte[] C;

        _A(Tag tag, int n2, byte[] byArray) {
            this.A = tag;
            this.B = n2;
            this.C = (byte[])byArray.clone();
        }

        Tag B() {
            return this.A;
        }

        int C() {
            return this.B;
        }

        byte[] A() {
            return (byte[])this.C.clone();
        }
    }
}

