/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.ext.dom.AttributeNodeModel;
import freemarker.ext.dom.CharacterDataNodeModel;
import freemarker.ext.dom.DocumentModel;
import freemarker.ext.dom.DocumentTypeModel;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.NodeOutputter;
import freemarker.ext.dom.PINodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.log.Logger;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateSequenceModel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class NodeModel
implements TemplateNodeModel,
TemplateHashModel,
TemplateSequenceModel {
    static final Logger logger = Logger.getLogger("freemarker.dom");
    private static DocumentBuilderFactory docBuilderFactory;
    private static Map xpathSupportMap;
    private static XPathSupport jaxenXPathSupport;
    private static ErrorHandler errorHandler;
    static Class xpathSupportClass;
    final Node node;
    private TemplateSequenceModel children;
    private NodeModel parent;
    static /* synthetic */ Class class$freemarker$ext$dom$XPathSupport;

    public static void setDocumentBuilderFactory(DocumentBuilderFactory docBuilderFactory) {
        NodeModel.docBuilderFactory = docBuilderFactory;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
        }
        return docBuilderFactory;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        NodeModel.errorHandler = errorHandler;
    }

    public static NodeModel parse(InputSource is, boolean removeComments, boolean removePIs) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = NodeModel.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        Document doc = builder.parse(is);
        if (removeComments && removePIs) {
            NodeModel.simplify(doc);
        } else {
            if (removeComments) {
                NodeModel.removeComments(doc);
            }
            if (removePIs) {
                NodeModel.removePIs(doc);
            }
            NodeModel.mergeAdjacentText(doc);
        }
        return NodeModel.wrap(doc);
    }

    public static NodeModel parse(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        return NodeModel.parse(is, true, true);
    }

    public static NodeModel parse(File f, boolean removeComments, boolean removePIs) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = NodeModel.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        Document doc = builder.parse(f);
        if (removeComments) {
            NodeModel.removeComments(doc);
        }
        if (removePIs) {
            NodeModel.removePIs(doc);
        }
        NodeModel.mergeAdjacentText(doc);
        return NodeModel.wrap(doc);
    }

    public static NodeModel parse(File f) throws SAXException, IOException, ParserConfigurationException {
        return NodeModel.parse(f, true, true);
    }

    protected NodeModel(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        XPathSupport xps;
        if (key.startsWith("@@")) {
            if (key.equals("@@text")) {
                return new SimpleScalar(NodeModel.getText(this.node));
            }
            if (key.equals("@@namespace")) {
                String nsURI = this.node.getNamespaceURI();
                return nsURI == null ? null : new SimpleScalar(nsURI);
            }
            if (key.equals("@@local_name")) {
                String localName = this.node.getLocalName();
                if (localName == null) {
                    localName = this.getNodeName();
                }
                return new SimpleScalar(localName);
            }
            if (key.equals("@@markup")) {
                StringBuffer buf = new StringBuffer();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node, buf);
                return new SimpleScalar(buf.toString());
            }
            if (key.equals("@@nested_markup")) {
                StringBuffer buf = new StringBuffer();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node.getChildNodes(), buf);
                return new SimpleScalar(buf.toString());
            }
            if (key.equals("@@qname")) {
                String qname = this.getQualifiedName();
                return qname == null ? null : new SimpleScalar(qname);
            }
        }
        if ((xps = this.getXPathSupport()) != null) {
            return xps.executeQuery(this.node, key);
        }
        throw new TemplateModelException("Can't try to resolve the XML query key, because no XPath support is available. It's either malformed or an XPath expression: " + key);
    }

    public TemplateNodeModel getParentNode() {
        if (this.parent == null) {
            Node parentNode = this.node.getParentNode();
            if (parentNode == null && this.node instanceof Attr) {
                parentNode = ((Attr)this.node).getOwnerElement();
            }
            this.parent = NodeModel.wrap(parentNode);
        }
        return this.parent;
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.children == null) {
            this.children = new NodeListModel(this.node.getChildNodes(), this);
        }
        return this.children;
    }

    public final String getNodeType() throws TemplateModelException {
        short nodeType = this.node.getNodeType();
        switch (nodeType) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "text";
            }
            case 8: {
                return "comment";
            }
            case 11: {
                return "document_fragment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document_type";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entity_reference";
            }
            case 12: {
                return "notation";
            }
            case 7: {
                return "pi";
            }
            case 3: {
                return "text";
            }
        }
        throw new TemplateModelException("Unknown node type: " + nodeType + ". This should be impossible!");
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Expecting exactly one arguments");
        }
        String query = (String)args.get(0);
        XPathSupport xps = this.getXPathSupport();
        if (xps == null) {
            throw new TemplateModelException("No XPath support available");
        }
        return xps.executeQuery(this.node, query);
    }

    public final int size() {
        return 1;
    }

    public final TemplateModel get(int i) {
        return i == 0 ? this : null;
    }

    public String getNodeNamespace() {
        short nodeType = this.node.getNodeType();
        if (nodeType != 2 && nodeType != 1) {
            return null;
        }
        String result = this.node.getNamespaceURI();
        if (result == null && nodeType == 1) {
            result = "";
        } else if ("".equals(result) && nodeType == 2) {
            result = null;
        }
        return result;
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && ((NodeModel)other).node.equals(this.node);
    }

    public static NodeModel wrap(Node node) {
        if (node == null) {
            return null;
        }
        NodeModel result = null;
        switch (node.getNodeType()) {
            case 9: {
                result = new DocumentModel((Document)node);
                break;
            }
            case 1: {
                result = new ElementModel((Element)node);
                break;
            }
            case 2: {
                result = new AttributeNodeModel((Attr)node);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                result = new CharacterDataNodeModel((CharacterData)node);
                break;
            }
            case 7: {
                result = new PINodeModel((ProcessingInstruction)node);
                break;
            }
            case 10: {
                result = new DocumentTypeModel((DocumentType)node);
            }
        }
        return result;
    }

    public static void removeComments(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                NodeModel.removeComments(child);
                ++i;
                continue;
            }
            if (child.getNodeType() == 8) {
                node.removeChild(child);
                --len;
                continue;
            }
            ++i;
        }
    }

    public static void removePIs(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                NodeModel.removePIs(child);
                ++i;
                continue;
            }
            if (child.getNodeType() == 7) {
                node.removeChild(child);
                --len;
                continue;
            }
            ++i;
        }
    }

    public static void mergeAdjacentText(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text || child instanceof CDATASection) {
                Node next = child.getNextSibling();
                if (!(next instanceof Text) && !(next instanceof CDATASection)) continue;
                String fullText = child.getNodeValue() + next.getNodeValue();
                ((CharacterData)child).setData(fullText);
                node.removeChild(next);
                continue;
            }
            NodeModel.mergeAdjacentText(child);
        }
    }

    public static void simplify(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        Node prevTextChild = null;
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                NodeModel.simplify(child);
                prevTextChild = null;
                ++i;
                continue;
            }
            short type = child.getNodeType();
            if (type == 7) {
                node.removeChild(child);
                --len;
                continue;
            }
            if (type == 8) {
                node.removeChild(child);
                --len;
                continue;
            }
            if (type == 3 || type == 4) {
                if (prevTextChild != null) {
                    CharacterData ptc = (CharacterData)prevTextChild;
                    ptc.setData(ptc.getNodeValue() + child.getNodeValue());
                    node.removeChild(child);
                    --len;
                    continue;
                }
                prevTextChild = child;
                ++i;
                continue;
            }
            prevTextChild = null;
            ++i;
        }
    }

    NodeModel getDocumentNodeModel() {
        if (this.node instanceof Document) {
            return this;
        }
        return NodeModel.wrap(this.node.getOwnerDocument());
    }

    public static void useDefaultXPathSupport() {
        xpathSupportClass = null;
        jaxenXPathSupport = null;
        try {
            NodeModel.useXalanXPathSupport();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (xpathSupportClass == null) {
            try {
                NodeModel.useJaxenXPathSupport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void useJaxenXPathSupport() throws Exception {
        Class.forName("org.jaxen.dom.DOMXPath");
        Class<?> c = Class.forName("freemarker.ext.dom.JaxenXPathSupport");
        jaxenXPathSupport = (XPathSupport)c.newInstance();
        if (logger.isDebugEnabled()) {
            logger.debug("Using Jaxen classes for XPath support");
        }
        xpathSupportClass = c;
    }

    public static void useXalanXPathSupport() throws Exception {
        Class.forName("org.apache.xpath.XPath");
        Class<?> c = Class.forName("freemarker.ext.dom.XalanXPathSupport");
        if (logger.isDebugEnabled()) {
            logger.debug("Using Xalan classes for XPath support");
        }
        xpathSupportClass = c;
    }

    public static void setXPathSupportClass(Class cl) {
        if (cl != null && !cl.isAssignableFrom(class$freemarker$ext$dom$XPathSupport == null ? (class$freemarker$ext$dom$XPathSupport = NodeModel.class$("freemarker.ext.dom.XPathSupport")) : class$freemarker$ext$dom$XPathSupport)) {
            throw new RuntimeException("Class " + cl.getName() + " does not implement freemarker.ext.dom.XPathSupport");
        }
        xpathSupportClass = cl;
    }

    public static Class getXPathSupportClass() {
        return xpathSupportClass;
    }

    private static String getText(Node node) {
        String result = "";
        if (node instanceof Text || node instanceof CDATASection) {
            result = ((CharacterData)node).getData();
        } else if (node instanceof Element) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                result = result + NodeModel.getText(children.item(i));
            }
        } else if (node instanceof Document) {
            result = NodeModel.getText(((Document)node).getDocumentElement());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XPathSupport getXPathSupport() {
        if (jaxenXPathSupport != null) {
            return jaxenXPathSupport;
        }
        XPathSupport xps = null;
        Document doc = this.node.getOwnerDocument();
        if (doc == null) {
            doc = (Document)this.node;
        }
        Document document = doc;
        synchronized (document) {
            WeakReference ref = (WeakReference)xpathSupportMap.get(doc);
            if (ref != null) {
                xps = (XPathSupport)ref.get();
            }
            if (xps == null) {
                try {
                    xps = (XPathSupport)xpathSupportClass.newInstance();
                    xpathSupportMap.put(doc, new WeakReference<XPathSupport>(xps));
                }
                catch (Exception e) {
                    logger.error("Error instantiating xpathSupport class");
                }
            }
        }
        return xps;
    }

    String getQualifiedName() throws TemplateModelException {
        return this.getNodeName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        xpathSupportMap = Collections.synchronizedMap(new WeakHashMap());
        NodeModel.useDefaultXPathSupport();
        if (xpathSupportClass == null && logger.isWarnEnabled()) {
            logger.warn("No XPath support is available.");
        }
    }
}

