/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.drools.util.FastComparator;
import org.drools.util.FastIterator;

public abstract class FastCollection
implements Collection,
Serializable {
    private FastComparator _valueComp = FastComparator.DEFAULT;
    private Unmodifiable _unmodifiable;

    protected FastCollection() {
    }

    public abstract int size();

    public abstract Record head();

    public abstract Record tail();

    public abstract Object valueOf(Record var1);

    public abstract void delete(Record var1);

    public Collection unmodifiable() {
        if (this._unmodifiable == null) {
            this._unmodifiable = new Unmodifiable();
        }
        return this._unmodifiable;
    }

    public Iterator iterator() {
        return FastIterator.valueOf(this);
    }

    public FastCollection setValueComparator(FastComparator fastComparator) {
        this._valueComp = fastComparator;
        return this;
    }

    public FastComparator getValueComparator() {
        return this._valueComp;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            if (!fastComparator.areEqual(object, this.valueOf(record))) continue;
            this.delete(record);
            return true;
        }
        return false;
    }

    public void clear() {
        Record record = this.head();
        for (Record record2 = this.tail().getPrevious(); record2 != record; record2 = record2.getPrevious()) {
            this.delete(record2);
        }
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            if (!fastComparator.areEqual(object, this.valueOf(record))) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof FastCollection) {
            return this.addAll((FastCollection)collection);
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean addAll(FastCollection fastCollection) {
        boolean bl = false;
        Record record = fastCollection.head();
        Record record2 = fastCollection.tail();
        while ((record = record.getNext()) != record2) {
            if (!this.add(fastCollection.valueOf(record))) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsAll(Collection collection) {
        if (collection instanceof FastCollection) {
            return this.containsAll((FastCollection)collection);
        }
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean containsAll(FastCollection fastCollection) {
        Record record = fastCollection.head();
        Record record2 = fastCollection.tail();
        while ((record = record.getNext()) != record2) {
            if (this.contains(fastCollection.valueOf(record))) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Record record = this.head();
        Record record2 = this.tail().getPrevious();
        while (record2 != record) {
            Record record3 = record2.getPrevious();
            if (collection.contains(this.valueOf(record2))) {
                this.delete(record2);
                bl = true;
            }
            record2 = record3;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Record record = this.head();
        Record record2 = this.tail().getPrevious();
        while (record2 != record) {
            Record record3 = record2.getPrevious();
            if (!collection.contains(this.valueOf(record2))) {
                this.delete(record2);
                bl = true;
            }
            record2 = record3;
        }
        return bl;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            throw new UnsupportedOperationException("Destination array too small");
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        int n2 = 0;
        Object[] objectArray2 = objectArray;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            objectArray2[n2++] = this.valueOf(record);
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            stringBuffer = stringBuffer.append(String.valueOf(record));
            if (record.getNext() == record2) continue;
            stringBuffer = stringBuffer.append(", ");
        }
        return stringBuffer.append(']').toString();
    }

    public boolean equals(Object object) {
        if (this instanceof List) {
            return this.equalsList(object);
        }
        return object == this || object instanceof Collection && ((Collection)object).size() == this.size() && this.containsAll((Collection)object);
    }

    private boolean equalsList(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            Record record = this.head();
            Iterator iterator = list.iterator();
            int n = this.size();
            while (n-- != 0) {
                Object e;
                Object object2 = this.valueOf(record = record.getNext());
                if (fastComparator.areEqual(object2, e = iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        FastComparator fastComparator = this.getValueComparator();
        int n = 0;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            n += fastComparator.hashCodeOf(this.valueOf(record));
        }
        return n;
    }

    private int hashCodeList() {
        FastComparator fastComparator = this.getValueComparator();
        int n = 1;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            n = 31 * n + fastComparator.hashCodeOf(this.valueOf(record));
        }
        return n;
    }

    private final class Unmodifiable
    extends FastCollection
    implements Set,
    List {
        private static final long serialVersionUID = -5929790997648211020L;

        private Unmodifiable() {
        }

        public int size() {
            return FastCollection.this.size();
        }

        public Record head() {
            return FastCollection.this.head();
        }

        public Record tail() {
            return FastCollection.this.tail();
        }

        public Object valueOf(Record record) {
            return FastCollection.this.valueOf(record);
        }

        public boolean contains(Object object) {
            return FastCollection.this.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return FastCollection.this.containsAll(collection);
        }

        public FastComparator getValueComparator() {
            return FastCollection.this.getValueComparator();
        }

        public FastCollection setValueComparator(FastComparator fastComparator) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void delete(Record record) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object get(int n) {
            return ((List)((Object)FastCollection.this)).get(n);
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public int indexOf(Object object) {
            return ((List)((Object)FastCollection.this)).indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return ((List)((Object)FastCollection.this)).lastIndexOf(object);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public ListIterator listIterator(int n) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public List subList(int n, int n2) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }

    public static interface Record {
        public Record getPrevious();

        public Record getNext();
    }
}

