/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaNodeBinder;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.FieldConstraint;

abstract class BetaNode
extends TupleSource
implements TupleSink,
ObjectSink,
NodeMemory {
    private final TupleSource leftInput;
    private final ObjectSource rightInput;
    private final BetaNodeBinder joinNodeBinder;

    BetaNode(int n, TupleSource tupleSource, ObjectSource objectSource) {
        this(n, tupleSource, objectSource, BetaNodeBinder.simpleBinder);
    }

    BetaNode(int n, TupleSource tupleSource, ObjectSource objectSource, BetaNodeBinder betaNodeBinder) {
        super(n);
        this.leftInput = tupleSource;
        this.rightInput = objectSource;
        this.joinNodeBinder = betaNodeBinder;
    }

    public FieldConstraint[] getConstraints() {
        if (this.joinNodeBinder == null) {
            return null;
        }
        return this.joinNodeBinder.getConstraints();
    }

    public void attach() {
        this.leftInput.addTupleSink(this);
        this.rightInput.addObjectSink(this);
    }

    public void attach(ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.attach();
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.leftInput.updateNewNode(reteooWorkingMemory, propagationContextImpl);
            this.rightInput.updateNewNode(reteooWorkingMemory, propagationContextImpl);
        }
    }

    public void remove(BaseNode baseNode, ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        if (!baseNode.isInUse()) {
            this.getTupleSinks().remove(baseNode);
        }
        this.removeShare();
        if (!this.isInUse()) {
            int n = reteooWorkingMemoryArray.length;
            for (int i = 0; i < n; ++i) {
                reteooWorkingMemoryArray[i].clearNodeMemory(this);
            }
        }
        this.rightInput.remove(this, reteooWorkingMemoryArray);
        this.leftInput.remove(this, reteooWorkingMemoryArray);
    }

    BetaNodeBinder getJoinNodeBinder() {
        return this.joinNodeBinder;
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BetaNode betaNode = (BetaNode)object;
        return this.leftInput.equals(betaNode.leftInput) && this.rightInput.equals(betaNode.rightInput) && this.joinNodeBinder.equals(betaNode.joinNodeBinder);
    }

    public Object createMemory(RuleBaseConfiguration ruleBaseConfiguration) {
        return new BetaMemory(ruleBaseConfiguration, this.getJoinNodeBinder());
    }
}

