/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class CharacterFactory {
    public static Evaluator getCharacterEvaluator(int n) {
        switch (n) {
            case 1: {
                return CharacterEqualEvaluator.INSTANCE;
            }
            case 10: {
                return CharacterNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return CharacterLessEvaluator.INSTANCE;
            }
            case 30: {
                return CharacterLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return CharacterGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return CharacterGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for CharacterEvaluator");
    }

    static class CharacterGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8587935558617586015L;
        private static final Evaluator INSTANCE = new CharacterGreaterOrEqualEvaluator();

        private CharacterGreaterOrEqualEvaluator() {
            super(100, 50);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Character)object).charValue() >= ((Character)object2).charValue();
        }

        public String toString() {
            return "Character >=";
        }
    }

    static class CharacterGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 7622623046585316842L;
        public static final Evaluator INSTANCE = new CharacterGreaterEvaluator();

        private CharacterGreaterEvaluator() {
            super(100, 40);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Character)object).charValue() > ((Character)object2).charValue();
        }

        public String toString() {
            return "Character >";
        }
    }

    static class CharacterLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8064001658173531244L;
        public static final Evaluator INSTANCE = new CharacterLessOrEqualEvaluator();

        private CharacterLessOrEqualEvaluator() {
            super(100, 30);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Character)object).charValue() <= ((Character)object2).charValue();
        }

        public String toString() {
            return "Character <=";
        }
    }

    static class CharacterLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5236106171143422684L;
        public static final Evaluator INSTANCE = new CharacterLessEvaluator();

        private CharacterLessEvaluator() {
            super(100, 20);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Character)object).charValue() < ((Character)object2).charValue();
        }

        public String toString() {
            return "Character <";
        }
    }

    static class CharacterNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8010152240062213440L;
        public static final Evaluator INSTANCE = new CharacterNotEqualEvaluator();

        private CharacterNotEqualEvaluator() {
            super(100, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return !((Character)object).equals(object2);
        }

        public String toString() {
            return "Character !=";
        }
    }

    static class CharacterEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8766645269581805269L;
        public static final Evaluator INSTANCE = new CharacterEqualEvaluator();

        private CharacterEqualEvaluator() {
            super(100, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return ((Character)object).equals(object2);
        }

        public String toString() {
            return "Character ==";
        }
    }
}

