/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.audit.event.ActivationLogEvent;
import org.drools.audit.event.ILogEventFilter;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.ObjectLogEvent;
import org.drools.common.InternalFactHandle;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.ObjectAssertedEvent;
import org.drools.event.ObjectModifiedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;

public abstract class WorkingMemoryLogger
implements WorkingMemoryEventListener,
AgendaEventListener {
    private final List filters = new ArrayList();
    private WorkingMemory workingMemory;

    public WorkingMemoryLogger(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        workingMemory.addEventListener(this);
        workingMemory.addEventListener(this);
    }

    public abstract void logEventCreated(LogEvent var1);

    private void filterLogEvent(LogEvent logEvent) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            ILogEventFilter iLogEventFilter = (ILogEventFilter)iterator.next();
            if (iLogEventFilter.acceptEvent(logEvent)) continue;
            return;
        }
        this.logEventCreated(logEvent);
    }

    public void addFilter(ILogEventFilter iLogEventFilter) {
        if (iLogEventFilter == null) {
            throw new NullPointerException();
        }
        this.filters.add(iLogEventFilter);
    }

    public void removeFilter(ILogEventFilter iLogEventFilter) {
        this.filters.remove(iLogEventFilter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void objectAsserted(ObjectAssertedEvent objectAssertedEvent) {
        this.filterLogEvent(new ObjectLogEvent(1, ((InternalFactHandle)objectAssertedEvent.getFactHandle()).getId(), objectAssertedEvent.getObject().toString()));
    }

    public void objectModified(ObjectModifiedEvent objectModifiedEvent) {
        this.filterLogEvent(new ObjectLogEvent(2, ((InternalFactHandle)objectModifiedEvent.getFactHandle()).getId(), objectModifiedEvent.getObject().toString()));
    }

    public void objectRetracted(ObjectRetractedEvent objectRetractedEvent) {
        this.filterLogEvent(new ObjectLogEvent(3, ((InternalFactHandle)objectRetractedEvent.getFactHandle()).getId(), objectRetractedEvent.getOldObject().toString()));
    }

    public void activationCreated(ActivationCreatedEvent activationCreatedEvent) {
        this.filterLogEvent(new ActivationLogEvent(4, WorkingMemoryLogger.getActivationId(activationCreatedEvent.getActivation()), activationCreatedEvent.getActivation().getRule().getName(), this.extractDeclarations(activationCreatedEvent.getActivation())));
    }

    public void activationCancelled(ActivationCancelledEvent activationCancelledEvent) {
        this.filterLogEvent(new ActivationLogEvent(5, WorkingMemoryLogger.getActivationId(activationCancelledEvent.getActivation()), activationCancelledEvent.getActivation().getRule().getName(), this.extractDeclarations(activationCancelledEvent.getActivation())));
    }

    public void beforeActivationFired(BeforeActivationFiredEvent beforeActivationFiredEvent) {
        this.filterLogEvent(new ActivationLogEvent(6, WorkingMemoryLogger.getActivationId(beforeActivationFiredEvent.getActivation()), beforeActivationFiredEvent.getActivation().getRule().getName(), this.extractDeclarations(beforeActivationFiredEvent.getActivation())));
    }

    public void afterActivationFired(AfterActivationFiredEvent afterActivationFiredEvent) {
        this.filterLogEvent(new ActivationLogEvent(7, WorkingMemoryLogger.getActivationId(afterActivationFiredEvent.getActivation()), afterActivationFiredEvent.getActivation().getRule().getName(), this.extractDeclarations(afterActivationFiredEvent.getActivation())));
    }

    private String extractDeclarations(Activation activation) {
        StringBuffer stringBuffer = new StringBuffer();
        Tuple tuple = activation.getTuple();
        Declaration[] declarationArray = activation.getRule().getDeclarations();
        int n = declarationArray.length;
        for (int i = 0; i < n; ++i) {
            Declaration declaration = declarationArray[i];
            InternalFactHandle internalFactHandle = tuple.get(declaration);
            if (internalFactHandle instanceof InternalFactHandle) {
                InternalFactHandle internalFactHandle2 = internalFactHandle;
                if (internalFactHandle2.getId() == -1L) continue;
                Object object = declaration.getValue(this.workingMemory.getObject(internalFactHandle));
                stringBuffer.append(declaration.getIdentifier());
                stringBuffer.append("=");
                if (object == null) {
                    stringBuffer.append("null");
                } else {
                    stringBuffer.append(object);
                    stringBuffer.append("(");
                    stringBuffer.append(internalFactHandle2.getId());
                    stringBuffer.append(")");
                }
            }
            if (i >= declarationArray.length - 1) continue;
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    private static String getActivationId(Activation activation) {
        StringBuffer stringBuffer = new StringBuffer(activation.getRule().getName());
        stringBuffer.append(" [");
        Tuple tuple = activation.getTuple();
        InternalFactHandle[] internalFactHandleArray = tuple.getFactHandles();
        for (int i = 0; i < internalFactHandleArray.length; ++i) {
            stringBuffer.append(internalFactHandleArray[i].getId());
            if (i >= internalFactHandleArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.append("]").toString();
    }
}

