/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetProvider;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.drools.compiler.PackageBuilder;
import org.drools.jsr94.rules.admin.LocalRuleExecutionSetProviderImpl;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.xml.XmlPackageReader;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class RuleExecutionSetProviderImpl
implements RuleExecutionSetProvider {
    public RuleExecutionSet createRuleExecutionSet(Element element, Map map) throws RuleExecutionSetCreateException {
        try {
            DOMSource dOMSource = new DOMSource(element);
            XmlPackageReader xmlPackageReader = new XmlPackageReader();
            SAXResult sAXResult = new SAXResult((ContentHandler)xmlPackageReader);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, sAXResult);
            PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
            PackageBuilder packageBuilder = new PackageBuilder();
            packageBuilder.addPackage(packageDescr);
            Package package_ = packageBuilder.getPackage();
            LocalRuleExecutionSetProviderImpl localRuleExecutionSetProviderImpl = new LocalRuleExecutionSetProviderImpl();
            return localRuleExecutionSetProviderImpl.createRuleExecutionSet((Object)package_, map);
        }
        catch (TransformerException transformerException) {
            throw new RuleExecutionSetCreateException("could not create RuleExecutionSet: " + transformerException);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Serializable serializable, Map map) throws RuleExecutionSetCreateException {
        if (serializable instanceof Package) {
            LocalRuleExecutionSetProviderImpl localRuleExecutionSetProviderImpl = new LocalRuleExecutionSetProviderImpl();
            return localRuleExecutionSetProviderImpl.createRuleExecutionSet(serializable, map);
        }
        throw new IllegalArgumentException("Serializable object must be an instance of org.drools.rule.RuleSet.  It was " + serializable.getClass().getName());
    }

    public RuleExecutionSet createRuleExecutionSet(String string, Map map) throws RuleExecutionSetCreateException, IOException {
        InputStream inputStream = null;
        try {
            LocalRuleExecutionSetProviderImpl localRuleExecutionSetProviderImpl = new LocalRuleExecutionSetProviderImpl();
            inputStream = new URL(string).openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            RuleExecutionSet ruleExecutionSet = localRuleExecutionSetProviderImpl.createRuleExecutionSet(inputStreamReader, map);
            return ruleExecutionSet;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

