/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SSLSocketClientInvoker
extends SocketClientInvoker {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$sslsocket$SSLSocketClientInvoker == null ? (class$org$jboss$remoting$transport$sslsocket$SSLSocketClientInvoker = SSLSocketClientInvoker.class$("org.jboss.remoting.transport.sslsocket.SSLSocketClientInvoker")) : class$org$jboss$remoting$transport$sslsocket$SSLSocketClientInvoker));
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    static /* synthetic */ Class class$org$jboss$remoting$transport$sslsocket$SSLSocketClientInvoker;

    public SSLSocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.error((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public SSLSocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.error((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (SSLSocketClientInvoker.isCompleteSocketFactory(sf)) {
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            this.socketFactory = wrapper;
            return wrapper;
        }
        return sf;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Object obj;
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            sf = this.createSocketFactory(this.configuration);
        }
        Socket s = sf.createSocket();
        s.setReuseAddress(this.getReuseAddress());
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        s.connect(inetAddr, timeout);
        if (s instanceof SSLSocket && (obj = this.configuration.get("handshakeCompletedListener")) != null && obj instanceof HandshakeCompletedListener) {
            SSLSocket sslSocket = (SSLSocket)s;
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            this.establishHandshake(sslSocket, listener);
        }
        return s;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

