/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.callback.Callback;

public class NullCallbackStore
implements SerializableStore,
Serializable {
    static final long serialVersionUID = -8182007953992756845L;
    private boolean isCallbackLost = false;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$callback$NullCallbackStore == null ? (class$org$jboss$remoting$callback$NullCallbackStore = NullCallbackStore.class$("org.jboss.remoting.callback.NullCallbackStore")) : class$org$jboss$remoting$callback$NullCallbackStore));
    static /* synthetic */ Class class$org$jboss$remoting$callback$NullCallbackStore;

    public int size() {
        return this.isCallbackLost ? 1 : 0;
    }

    public Object getNext() throws IOException {
        if (this.isCallbackLost) {
            this.isCallbackLost = false;
            return new FailedCallback("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
        }
        return null;
    }

    public void add(Serializable object) throws IOException {
        this.isCallbackLost = true;
        log.error((Object)("Lost callback because not enough free memory available.  Callback lost was " + object));
        throw new IOException("Callback has been lost because not enough free memory to hold object.");
    }

    public void setConfig(Map config) {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void create() throws Exception {
    }

    public void destroy() {
    }

    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
    }

    public boolean getPurgeOnShutdown() {
        return false;
    }

    public void purgeFiles() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FailedCallback
    extends Callback {
        public FailedCallback(Object callbackPayload) {
            super(callbackPayload);
        }

        public Object getCallbackObject() {
            throw new RuntimeException("This is an invalid callback.  The server ran out of memory, so callbacks were lost.");
        }
    }
}

