/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

public class DocumentData {
    byte[] data;
    DocType docType;
    String baseName;

    public DocumentData(String baseName, DocType docType, byte[] data) {
        this.data = data;
        this.docType = docType;
        this.baseName = baseName;
    }

    public byte[] getData() {
        return this.data;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getFileName() {
        return this.getBaseName() + "." + this.getDocType().getExtension();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocType {
        PDF("pdf", "application/pdf"),
        RTF("rtf", "text/rtf"),
        HTML("html", "text/html");

        private String mimeType;
        private String extension;

        private DocType(String extension, String mimeType) {
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

