/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.skin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactoryImpl;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SkinFactory {
    private static Map instances = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog((Class)SkinFactory.class);
    public static final String SERVICE_RESOURCE = "META-INF/services/" + SkinFactory.class.getName();
    public static final String SKIN_PARAMETER = "org.ajax4jsf.SKIN";

    public static void reset() {
        instances = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SkinFactory getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SkinFactory instance = (SkinFactory)instances.get(loader);
        if (instance == null) {
            InputStream input = null;
            input = loader.getResourceAsStream(SERVICE_RESOURCE);
            if (input != null) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    String factoryClassName = reader.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage(Messages.SET_SKIN_FACTORY_INFO, factoryClassName));
                    }
                    Class<?> clazz = Class.forName(factoryClassName);
                    try {
                        Constructor<?> factoryConstructor = clazz.getConstructor(SkinFactory.class);
                        instance = (SkinFactory)factoryConstructor.newInstance(instance);
                    }
                    catch (NoSuchMethodException e) {
                        instance = (SkinFactory)clazz.newInstance();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)Messages.getMessage(Messages.CREATING_SKIN_FACTORY_ERROR), (Throwable)e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (instance == null) {
                instance = new SkinFactoryImpl();
            }
            instances.put(loader, instance);
        }
        return instance;
    }

    public abstract Skin getSkin(FacesContext var1);

    protected static boolean isValueReference(String value) {
        int end;
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        return start >= 0 && (end = value.lastIndexOf(125)) >= 0 && start < end;
    }
}

