/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.renderer.AjaxChildrenRenderer;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxContainerRenderer
extends AjaxChildrenRenderer {
    public static final String AJAX_PARAMETER_NAME = "AJAXREQUEST";
    public static final String AJAX_JSF_SCRIPT = "AJAX.js";
    public static final String SARISSA_SCRIPT = "sarissa.js";
    public static final String JSDOM_SCRIPT = "JSDOM_sarissa.js";
    public static final String AJAX_VIEW_STATE_TAG = "span";
    public static final String AJAX_VIEW_STATE_ID = "ajax-update-ids";
    public static final String AJAX_RESULT_GROUP_TAG = "meta";
    public static final String AJAX_RESULT_GROUP_ATTR = "content";
    public static final String AJAX_RESULT_STYLE = "display: none";
    public static final String AJAX_UPDATE_HEADER = "Ajax-Update-Ids";
    static final Log log = LogFactory.getLog((Class)AjaxContainerRenderer.class);
    public static final String AJAX_FLAG_HEADER = "Ajax-Response";
    public static final String AJAX_LOCATION_HEADER = "Location";

    protected Class getComponentClass() {
        return AjaxContainer.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        log.debug((Object)Messages.getMessage(Messages.RENDER_CHILDREN_NON_AJAX_INFO));
        this.renderChildren(context, component);
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        AjaxContainer container = (AjaxContainer)component;
        log.debug((Object)Messages.getMessage(Messages.RENDER_CHILDREN_AJAX_INFO));
        Set ids = AjaxRendererUtils.getSubmittedAjaxContainer(context, container).getAjaxAreasToRender();
        Set renderedAreas = container.getAjaxRenderedAreas();
        if (!container.isRenderRegionOnly()) {
            component = context.getViewRoot();
        }
        String path = AjaxRendererUtils.getAbsoluteId(component);
        path = path.substring(0, path.lastIndexOf(58) + 1);
        this.encodeAjaxChild(context, component, path, ids, renderedAreas);
        AjaxRendererUtils.encodeAreas(context, component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void preDecode(FacesContext context, UIComponent component) {
        Object ajaxParameter;
        super.preDecode(context, component);
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.DECODE_AJAX_REQUEST_STATUS_INFO, clientId));
            log.debug((Object)Messages.getMessage(Messages.REQUEST_PARAMETERS_MAP, paramMap.toString()));
        }
        if (null != (ajaxParameter = paramMap.get(AJAX_PARAMETER_NAME))) {
            ((AjaxContainer)component).setAjaxRequest(true);
            if (ajaxParameter.equals(clientId)) {
                ((AjaxContainer)component).setSubmitted(true);
            }
        } else {
            ((AjaxContainer)component).setSubmitted(false);
            ((AjaxContainer)component).setAjaxRequest(false);
        }
    }
}

