/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.ajax.AjaxChildrenEncoder;
import org.ajax4jsf.framework.ajax.AjaxOutput;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AjaxChildrenRenderer
extends AjaxComponentRendererBase {
    public static final Log log = LogFactory.getLog((Class)AjaxChildrenRenderer.class);
    public static final String[] SPECIAL_COMPONENTS_TYPES = new String[]{"org.ajax4jsf.ajax.Bundle", "org.apache.myfaces.AliasBean", "org.apache.myfaces.AliasBeansScope"};
    private static final String SPECIAL_TYPES_PARAMETER = "org.ajax4jsf.CONTROL_COMPONENTS";
    private Set _specialComponentTypes = null;

    public void encodeAjaxChild(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_CHILD_AJAX_INFO, path, component.getId()));
        }
        String currentPath = path;
        if (component instanceof NamingContainer) {
            currentPath = currentPath + component.getId() + ':';
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            boolean found = false;
            UIComponent element = (UIComponent)it.next();
            if (!element.isRendered()) continue;
            if (!ids.isEmpty()) {
                String elementId = element.getId();
                String absoluteId = currentPath + elementId;
                if (ids.contains(absoluteId) || ids.contains(elementId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage(Messages.RENDER_AJAX_AREA_INFO, absoluteId));
                    }
                    found = true;
                }
            }
            if (element instanceof AjaxOutput && ((AjaxOutput)element).isAjaxRendered()) {
                found = true;
            }
            if (!found) {
                if (element instanceof AjaxChildrenEncoder) {
                    ((AjaxChildrenEncoder)element).encodeAjaxChild(context, currentPath, ids, renderedAreas);
                    continue;
                }
                boolean special = this.isSpecialElement(context, element);
                if (special) {
                    element.encodeBegin(context);
                }
                this.encodeAjaxChild(context, element, currentPath, ids, renderedAreas);
                if (!special) continue;
                element.encodeEnd(context);
                continue;
            }
            renderedAreas.add(element.getClientId(context));
            this.renderChild(context, element);
        }
    }

    private boolean isSpecialElement(FacesContext context, UIComponent component) {
        boolean result;
        if (this._specialComponentTypes == null) {
            this._specialComponentTypes = new HashSet(10);
            for (int i = 0; i < SPECIAL_COMPONENTS_TYPES.length; ++i) {
                this._specialComponentTypes.add(SPECIAL_COMPONENTS_TYPES[i]);
            }
            String special = context.getExternalContext().getInitParameter(SPECIAL_TYPES_PARAMETER);
            if (null != special) {
                String[] split = special.split(",");
                for (int i = 0; i < split.length; ++i) {
                    this._specialComponentTypes.add(split[i]);
                }
            }
        }
        try {
            String componentType = (String)component.getClass().getField("COMPONENT_TYPE").get(null);
            result = this._specialComponentTypes.contains(componentType);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

