/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import org.mockejb.interceptor.AspectException;
import org.mockejb.interceptor.AspectSystem;
import org.mockejb.interceptor.AspectSystemImpl;

public class AspectSystemFactory {
    public static final String ASPECT_SYSTEM_PROPERTY = "interceptor.aspect.system.class";
    public static final String THREAD_LOCAL_ASPECT_SYSTEM = "interceptor.aspect.system.thread";
    private static AspectSystem aspectSystem = AspectSystemFactory.loadAspectSystem();
    private static ThreadLocal aspectSystemForThread = new ThreadLocal(){

        protected Object initialValue() {
            return AspectSystemFactory.loadAspectSystem();
        }
    };
    static /* synthetic */ Class class$org$mockejb$interceptor$AspectSystemFactory;

    private static AspectSystem loadAspectSystem() {
        AspectSystem aspectSystem;
        String aspectSystemClassName = System.getProperty(ASPECT_SYSTEM_PROPERTY);
        if (aspectSystemClassName != null) {
            try {
                Class<?> aspectSystemClass = Class.forName(aspectSystemClassName, true, (class$org$mockejb$interceptor$AspectSystemFactory == null ? (class$org$mockejb$interceptor$AspectSystemFactory = AspectSystemFactory.class$("org.mockejb.interceptor.AspectSystemFactory")) : class$org$mockejb$interceptor$AspectSystemFactory).getClassLoader());
                aspectSystem = (AspectSystem)aspectSystemClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new AspectException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new AspectException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new AspectException(iae);
            }
        } else {
            aspectSystem = new AspectSystemImpl();
        }
        return aspectSystem;
    }

    public static AspectSystem getAspectSystem() {
        String threadLocalAspectSystemProp = System.getProperty(THREAD_LOCAL_ASPECT_SYSTEM);
        if (threadLocalAspectSystemProp != null && threadLocalAspectSystemProp.equalsIgnoreCase("true")) {
            return (AspectSystem)aspectSystemForThread.get();
        }
        return aspectSystem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

