/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.core.v2.ProtocolConnectionImpl;
import org.postgresql.util.GT;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;

    public ProtocolConnection openConnectionImpl(String host, int port, String user, String database, Properties info) throws SQLException {
        boolean requireSSL;
        boolean trySSL = requireSSL = info.getProperty("ssl") != null;
        if (Driver.logDebug) {
            Driver.debug("Trying to establish a protocol version 2 connection to " + host + ":" + port);
        }
        if (!Driver.sslEnabled()) {
            if (requireSSL) {
                throw new PSQLException(GT.tr("The driver does not support SSL."), PSQLState.CONNECTION_FAILURE);
            }
            trySSL = false;
        }
        PGStream newStream = null;
        try {
            newStream = new PGStream(host, port);
            if (trySSL) {
                newStream = this.enableSSL(newStream, requireSSL, info);
            }
            this.sendStartupPacket(newStream, user, database);
            this.doAuthentication(newStream, user, info.getProperty("password"));
            ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database);
            this.readStartupMessages(newStream, protoConnection);
            this.runInitialQueries(protoConnection, info.getProperty("charSet"));
            return protoConnection;
        }
        catch (ConnectException cex) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_REJECTED, (Throwable)cex);
        }
        catch (IOException ioe) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw se;
        }
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info) throws IOException, SQLException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                pgStream.close();
                return new PGStream(pgStream.getHost(), pgStream.getPort());
            }
            case 78: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                return pgStream;
            }
            case 83: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLOk");
                }
                Driver.makeSSL(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.CONNECTION_FAILURE);
    }

    private void sendStartupPacket(PGStream pgStream, String user, String database) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> StartupPacket(user=" + user + ",database=" + database + ")");
        }
        pgStream.SendInteger4(296);
        pgStream.SendInteger2(2);
        pgStream.SendInteger2(0);
        pgStream.Send(database.getBytes("US-ASCII"), 64);
        pgStream.Send(user.getBytes("US-ASCII"), 32);
        pgStream.Send(new byte[64]);
        pgStream.Send(new byte[64]);
        pgStream.Send(new byte[64]);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String user, String password) throws IOException, SQLException {
        block10: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    String errorMsg = pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(GT.tr("Connection rejected: {0}.", errorMsg), PSQLState.CONNECTION_REJECTED);
                }
                case 82: {
                    int areq = pgStream.ReceiveIntegerR(4);
                    switch (areq) {
                        case 4: {
                            String salt = pgStream.ReceiveString(2);
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqCrypt(salt='" + salt + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            String result = UnixCrypt.crypt(salt, password);
                            byte[] encodedResult = result.getBytes("US-ASCII");
                            if (Driver.logDebug) {
                                Driver.debug(" FE=> Password(crypt='" + result + "')");
                            }
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 5: {
                            byte[] md5Salt = pgStream.Receive(4);
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user, password, md5Salt);
                            if (Driver.logDebug) {
                                Driver.debug(" FE=> Password(md5digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 3: {
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqPassword");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            if (Driver.logDebug) {
                                Driver.debug(" FE=> Password(password=<not shown>)");
                            }
                            byte[] encodedPassword = password.getBytes("US-ASCII");
                            pgStream.SendInteger4(4 + encodedPassword.length + 1);
                            pgStream.Send(encodedPassword);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 0: {
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection) throws IOException, SQLException {
        block6: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery");
                    }
                    return;
                }
                case 75: {
                    int pid = pgStream.ReceiveIntegerR(4);
                    int ckey = pgStream.ReceiveIntegerR(4);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block6;
                }
                case 69: {
                    String errorMsg = pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ErrorResponse(" + errorMsg + ")");
                    }
                    throw new PSQLException(GT.tr("Backend start-up failed: {0}.", errorMsg), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                case 78: {
                    String warnMsg = pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE NoticeResponse(" + warnMsg + ")");
                    }
                    protoConnection.addWarning(new SQLWarning(warnMsg));
                    continue block6;
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private byte[][] runSetupQuery(ProtocolConnectionImpl protoConnection, String queryString, boolean wantResults) throws SQLException {
        QueryExecutor executor = protoConnection.getQueryExecutor();
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler(protoConnection);
        int flags = 17;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, (ResultHandler)handler, 0, 0, flags);
            Object var9_8 = null;
            query.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            query.close();
            throw throwable;
        }
        if (!wantResults) {
            return null;
        }
        Vector tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new PSQLException(GT.tr("An unexpected result was returned by a query."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (byte[][])tuples.elementAt(0);
    }

    private void runInitialQueries(ProtocolConnectionImpl protoConnection, String charSet) throws SQLException, IOException {
        byte[][] results = this.runSetupQuery(protoConnection, "set datestyle = 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end", true);
        String rawDbVersion = protoConnection.getEncoding().decode(results[0]);
        StringTokenizer versionParts = new StringTokenizer(rawDbVersion);
        versionParts.nextToken();
        String dbVersion = versionParts.nextToken();
        protoConnection.setServerVersion(dbVersion);
        if (dbVersion.compareTo("7.3") >= 0) {
            if (Driver.logDebug) {
                Driver.debug("Switching to UNICODE client_encoding");
            }
            this.runSetupQuery(protoConnection, "begin; set autocommit = on; set client_encoding = 'UNICODE'; commit", false);
            protoConnection.setEncoding(Encoding.getDatabaseEncoding("UNICODE"));
        } else {
            String dbEncoding;
            String string = dbEncoding = results[1] == null ? null : protoConnection.getEncoding().decode(results[1]);
            if (Driver.logDebug) {
                Driver.debug("Specified charset:  " + charSet);
                Driver.debug("Database encoding: " + dbEncoding);
            }
            if (charSet != null) {
                protoConnection.setEncoding(Encoding.getJVMEncoding(charSet));
            } else if (dbEncoding != null) {
                protoConnection.setEncoding(Encoding.getDatabaseEncoding(dbEncoding));
            } else {
                protoConnection.setEncoding(Encoding.defaultEncoding());
            }
        }
        if (Driver.logDebug) {
            Driver.debug("Connection encoding (using JVM's nomenclature): " + protoConnection.getEncoding());
        }
    }

    private class SimpleResultHandler
    implements ResultHandler {
        private SQLException error;
        private Vector tuples;
        private final ProtocolConnectionImpl protoConnection;

        SimpleResultHandler(ProtocolConnectionImpl protoConnection) {
            this.protoConnection = protoConnection;
        }

        Vector getResults() {
            return this.tuples;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.tuples = tuples;
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        public void handleWarning(SQLWarning warning) {
            this.protoConnection.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

