/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.jboss.logging.Logger;

public class JavaUtils {
    private static final Logger log = Logger.getLogger(JavaUtils.class);
    private static HashMap<String, Class> primitiveNames = new HashMap();

    public static Class loadJavaType(String typeName) throws ClassNotFoundException {
        return JavaUtils.loadJavaType(typeName, null);
    }

    public static Class loadJavaType(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> javaType;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((javaType = primitiveNames.get(typeName)) == null) {
            javaType = JavaUtils.getArray(typeName, classLoader);
        }
        if (javaType == null) {
            javaType = classLoader.loadClass(typeName);
        }
        return javaType;
    }

    public static boolean isPrimitive(String javaType) {
        return JavaUtils.getPrimitiveType(javaType) != null;
    }

    public static boolean isPrimitive(Class javaType) {
        return javaType.isPrimitive() || javaType.isArray() && JavaUtils.isPrimitive(javaType.getComponentType());
    }

    public static Class getPrimitiveType(String javaType) {
        Class type = primitiveNames.get(javaType);
        if (type != null) {
            return type;
        }
        try {
            type = JavaUtils.getArray(javaType, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return type;
    }

    private static Class getArray(String javaType, ClassLoader loader) throws ClassNotFoundException {
        if (javaType.charAt(0) == '[') {
            return JavaUtils.getArrayFromJVMName(javaType, loader);
        }
        if (javaType.endsWith("[]")) {
            return JavaUtils.getArrayFromSourceName(javaType, loader);
        }
        return null;
    }

    private static Class getArrayFromJVMName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        Class<Constable> componentType;
        int componentStart = javaType.lastIndexOf(91) + 1;
        switch (javaType.charAt(componentStart)) {
            case 'I': {
                componentType = Integer.TYPE;
                break;
            }
            case 'S': {
                componentType = Short.TYPE;
                break;
            }
            case 'Z': {
                componentType = Boolean.TYPE;
                break;
            }
            case 'B': {
                componentType = Byte.TYPE;
                break;
            }
            case 'J': {
                componentType = Long.TYPE;
                break;
            }
            case 'D': {
                componentType = Double.TYPE;
                break;
            }
            case 'F': {
                componentType = Float.TYPE;
                break;
            }
            case 'C': {
                componentType = Character.TYPE;
                break;
            }
            case 'L': {
                if (loader == null) {
                    return null;
                }
                String name = javaType.substring(componentStart + 1, javaType.length() - 1);
                componentType = loader.loadClass(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid binary component for array: " + javaType.charAt(componentStart));
            }
        }
        return Array.newInstance(componentType, new int[componentStart]).getClass();
    }

    private static Class getArrayFromSourceName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        int arrayStart = javaType.indexOf(91);
        String componentName = javaType.substring(0, arrayStart);
        Class<?> componentType = primitiveNames.get(componentName);
        if (componentType == null) {
            if (loader == null) {
                return null;
            }
            componentType = loader.loadClass(componentName);
        }
        int dimensions = javaType.length() - arrayStart >> 1;
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static Class getPrimitiveType(Class javaType) {
        if (javaType == Integer.class) {
            return Integer.TYPE;
        }
        if (javaType == Short.class) {
            return Short.TYPE;
        }
        if (javaType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (javaType == Byte.class) {
            return Byte.TYPE;
        }
        if (javaType == Long.class) {
            return Long.TYPE;
        }
        if (javaType == Double.class) {
            return Double.TYPE;
        }
        if (javaType == Float.class) {
            return Float.TYPE;
        }
        if (javaType == Character.class) {
            return Character.TYPE;
        }
        if (javaType == Integer[].class) {
            return int[].class;
        }
        if (javaType == Short[].class) {
            return short[].class;
        }
        if (javaType == Boolean[].class) {
            return boolean[].class;
        }
        if (javaType == Byte[].class) {
            return byte[].class;
        }
        if (javaType == Long[].class) {
            return long[].class;
        }
        if (javaType == Double[].class) {
            return double[].class;
        }
        if (javaType == Float[].class) {
            return float[].class;
        }
        if (javaType == Character[].class) {
            return char[].class;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getPrimitiveType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getPrimitiveValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType == Integer.class) {
            return (int)((Integer)value);
        }
        if (javaType == Short.class) {
            return (short)((Short)value);
        }
        if (javaType == Boolean.class) {
            return (boolean)((Boolean)value);
        }
        if (javaType == Byte.class) {
            return (byte)((Byte)value);
        }
        if (javaType == Long.class) {
            return (long)((Long)value);
        }
        if (javaType == Double.class) {
            return (double)((Double)value);
        }
        if (javaType == Float.class) {
            return Float.valueOf(((Float)value).floatValue());
        }
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getPrimitiveType(javaType.getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Object srcObj = Array.get(value, i);
                Object destObj = JavaUtils.getPrimitiveValue(srcObj);
                Array.set(destArr, i, destObj);
            }
            return destArr;
        }
        return value;
    }

    public static Class getWrapperType(Class javaType) {
        if (javaType == Integer.TYPE) {
            return Integer.class;
        }
        if (javaType == Short.TYPE) {
            return Short.class;
        }
        if (javaType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (javaType == Byte.TYPE) {
            return Byte.class;
        }
        if (javaType == Long.TYPE) {
            return Long.class;
        }
        if (javaType == Double.TYPE) {
            return Double.class;
        }
        if (javaType == Float.TYPE) {
            return Float.class;
        }
        if (javaType == Character.TYPE) {
            return Character.class;
        }
        if (javaType == int[].class) {
            return Integer[].class;
        }
        if (javaType == short[].class) {
            return Short[].class;
        }
        if (javaType == boolean[].class) {
            return Boolean[].class;
        }
        if (javaType == byte[].class) {
            return Byte[].class;
        }
        if (javaType == long[].class) {
            return Long[].class;
        }
        if (javaType == double[].class) {
            return Double[].class;
        }
        if (javaType == float[].class) {
            return Float[].class;
        }
        if (javaType == char[].class) {
            return Character[].class;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getWrapperType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getWrapperValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType == Integer.TYPE) {
            return Integer.valueOf("" + value);
        }
        if (javaType == Short.TYPE) {
            return Short.valueOf("" + value);
        }
        if (javaType == Boolean.TYPE) {
            return Boolean.valueOf("" + value);
        }
        if (javaType == Byte.TYPE) {
            return Byte.valueOf("" + value);
        }
        if (javaType == Long.TYPE) {
            return Long.valueOf("" + value);
        }
        if (javaType == Double.TYPE) {
            return Double.valueOf("" + value);
        }
        if (javaType == Float.TYPE) {
            return Float.valueOf("" + value);
        }
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getWrapperType(javaType.getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Object srcObj = Array.get(value, i);
                Object destObj = JavaUtils.getWrapperValue(srcObj);
                Array.set(destArr, i, destObj);
            }
            return destArr;
        }
        return value;
    }

    public static boolean isAssignableFrom(Class dest, Class src) {
        if (dest == null) {
            throw new IllegalArgumentException("Destination class cannot be null");
        }
        if (src == null) {
            throw new IllegalArgumentException("Source class cannot be null");
        }
        boolean isAssignable = dest.isAssignableFrom(src);
        if (!isAssignable && dest.getName().equals(src.getName())) {
            ClassLoader destLoader = dest.getClassLoader();
            ClassLoader srcLoader = src.getClassLoader();
            log.debug((Object)("Not assignable because of conflicting class loaders:\ndstLoader=" + destLoader + "\nsrcLoader=" + srcLoader));
        }
        if (!isAssignable && JavaUtils.isPrimitive(dest)) {
            dest = JavaUtils.getWrapperType(dest);
            isAssignable = dest.isAssignableFrom(src);
        }
        if (!isAssignable && JavaUtils.isPrimitive(src)) {
            src = JavaUtils.getWrapperType(src);
            isAssignable = dest.isAssignableFrom(src);
        }
        return isAssignable;
    }

    public static String convertJVMNameToSourceName(String typeName, ClassLoader loader) {
        try {
            Class javaType = JavaUtils.loadJavaType(typeName, loader);
            typeName = JavaUtils.getSourceName(javaType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeName;
    }

    public static String getSourceName(Class type) {
        if (!type.isArray()) {
            return type.getName();
        }
        String arrayNotation = "";
        Class<?> component = type;
        while (component.isArray()) {
            component = component.getComponentType();
            arrayNotation = arrayNotation + "[]";
        }
        return component.getName() + arrayNotation;
    }

    static {
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("double", Double.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("char", Character.TYPE);
    }
}

