/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;

public class BaseCacheLoaderInterceptor
extends Interceptor {
    protected CacheLoader loader = null;
    private Map lockMap = new ConcurrentReaderHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void obtainLoaderLock(Object lock) {
        Thread current = Thread.currentThread();
        BaseCacheLoaderInterceptor baseCacheLoaderInterceptor = this;
        synchronized (baseCacheLoaderInterceptor) {
            while (this.lockMap.containsKey(lock) && !this.lockMap.get(lock).equals(current)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.lockMap.containsKey(lock) && !this.lockMap.get(lock).equals(current)) {
                throw new ConcurrentModificationException("Loader lock " + lock + " is already held by someone else.");
            }
            this.lockMap.put(lock, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLoaderLock(Object lock) {
        BaseCacheLoaderInterceptor baseCacheLoaderInterceptor = this;
        synchronized (baseCacheLoaderInterceptor) {
            this.lockMap.remove(lock);
            this.notify();
        }
    }

    protected void releaseLoaderLocks(List locks) {
        Iterator it = locks.iterator();
        while (it.hasNext()) {
            this.releaseLoaderLock(it.next());
        }
    }

    protected void obtainLoaderLocks(List locks) {
        Iterator it = locks.iterator();
        while (it.hasNext()) {
            this.obtainLoaderLock(it.next());
        }
    }
}

