/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

public class LRUQueue
implements EvictionQueue {
    private Map maxAgeQueue = new LinkedHashMap();
    private Map lruQueue = new LinkedHashMap(16, 0.75f, true);
    private long alternatingCount = 0L;
    private int numElements = 0;

    LRUQueue() {
    }

    void reorderByLRU(Fqn fqn) {
        this.lruQueue.get(fqn);
    }

    public NodeEntry getFirstNodeEntry() {
        NodeEntry ne;
        if (this.alternatingCount % 2L == 0L) {
            ne = this.getFirstLRUNodeEntry();
            if (ne == null) {
                ne = this.getFirstMaxAgeNodeEntry();
            }
        } else {
            ne = this.getFirstMaxAgeNodeEntry();
            if (ne == null) {
                ne = this.getFirstLRUNodeEntry();
            }
        }
        ++this.alternatingCount;
        return ne;
    }

    public NodeEntry getFirstLRUNodeEntry() {
        if (this.lruQueue.size() > 0) {
            return (NodeEntry)this.lruQueue.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getFirstMaxAgeNodeEntry() {
        if (this.maxAgeQueue.size() > 0) {
            return (NodeEntry)this.maxAgeQueue.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return (NodeEntry)this.lruQueue.get(fqn);
    }

    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        return this.maxAgeQueue.containsKey(entry.getFqn());
    }

    void removeNodeEntryFromLRU(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        this.lruQueue.remove(fqn);
    }

    void removeNodeEntryFromMaxAge(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        this.maxAgeQueue.remove(fqn);
    }

    public void removeNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            return;
        }
        Fqn fqn = entry.getFqn();
        NodeEntry ne1 = (NodeEntry)this.lruQueue.remove(fqn);
        NodeEntry ne2 = (NodeEntry)this.maxAgeQueue.remove(fqn);
        if (ne1 == null || ne2 == null) {
            throw new RuntimeException("The queues are out of sync.");
        }
        this.numElements -= ne1.getNumberOfElements();
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            entry.queue = this;
            this.maxAgeQueue.put(fqn, entry);
            this.lruQueue.put(fqn, entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    public int getNumberOfNodes() {
        return this.maxAgeQueue.size();
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public void clear() {
        this.maxAgeQueue.clear();
        this.lruQueue.clear();
        this.numElements = 0;
    }

    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    public Iterator iterate() {
        return this.lruQueue.values().iterator();
    }

    final Iterator iterateMaxAgeQueue() {
        return this.maxAgeQueue.values().iterator();
    }

    final Iterator iterateLRUQueue() {
        return this.lruQueue.values().iterator();
    }
}

