/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class CachedListAbstract
implements List {
    public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objs[i] = this.get(i);
        }
        return objs;
    }

    public Object[] toArray(Object[] a) {
        int looper;
        int actualLength = this.size();
        if (actualLength > a.length) {
            a = new Object[actualLength];
        }
        for (looper = 0; looper < actualLength; ++looper) {
            a[looper] = this.get(looper);
        }
        while (looper < a.length) {
            a[looper] = null;
            ++looper;
        }
        return a;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (c.size() == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.add(index++, o);
        }
        return true;
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.add(o);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.remove(o);
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            Object o = this.get(i);
            result = 31 * result + (o == null ? 0 : o.hashCode());
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value1 = this.get(i);
            Object value2 = list.get(i);
            if ((value1 != null || value2 == null) && (value1 == null || value1.equals(value2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            buf.append("[").append(key).append("]");
            if (i > size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean retainAll(Collection c) {
        boolean changedAnything = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            changedAnything = true;
        }
        return changedAnything;
    }
}

