/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.base.ClassFieldExtractor;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.LiteralConstraint;
import org.drools.spi.FieldConstraint;
import org.drools.util.ReflectiveVisitor;
import org.drools.visualize.ReteooJungViewer;

public class ReteooToJungVisitor
extends ReflectiveVisitor {
    private static final String NULL_STRING = "<NULL>";
    private static final String INDENT = "    ";
    private final Map visitedNodes = new HashMap();
    private Graph graph;
    private Vertex rootVertex;
    private Vertex parentVertex;

    public ReteooToJungVisitor(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Vertex getRootVertex() {
        return this.rootVertex;
    }

    public void visitReteooRuleBase(ReteooRuleBase reteooRuleBase) {
        this.visit(reteooRuleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.rootVertex = (ReteNodeVertex)this.visitedNodes.get(ReteooToJungVisitor.dotId(rete));
        if (this.rootVertex == null) {
            this.rootVertex = new ReteNodeVertex(rete);
            this.visitedNodes.put(ReteooToJungVisitor.dotId(rete), this.rootVertex);
        }
        this.graph.addVertex(this.rootVertex);
        this.parentVertex = this.rootVertex;
        Iterator iterator = rete.objectTypeNodeIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.visitNode(e);
        }
    }

    public void visitBaseNode(BaseNode baseNode) {
        Vertex vertex = (Vertex)this.visitedNodes.get(ReteooToJungVisitor.dotId(baseNode));
        if (vertex == null) {
            Object object;
            String string;
            try {
                string = baseNode.getClass().getName();
                string = string.substring(string.lastIndexOf(46) + 1) + "Vertex";
                object = Class.forName("org.drools.reteoo.ReteooToJungVisitor$" + string);
                vertex = (Vertex)((Class)object).getConstructor(baseNode.getClass()).newInstance(baseNode);
            }
            catch (Exception exception) {
                throw new RuntimeException("problem visiting node " + baseNode.getClass().getName(), exception);
            }
            this.graph.addVertex(vertex);
            this.visitedNodes.put(ReteooToJungVisitor.dotId(baseNode), vertex);
            this.graph.addEdge((Edge)new DroolsDirectedEdge(this.parentVertex, vertex));
            string = this.parentVertex;
            this.parentVertex = vertex;
            object = null;
            if (baseNode instanceof ObjectSource) {
                object = ((ObjectSource)baseNode).getObjectSinksAsList();
            } else if (baseNode instanceof TupleSource) {
                object = ((TupleSource)baseNode).getTupleSinks();
            }
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    this.visitNode(e);
                }
            }
            this.parentVertex = string;
        } else {
            this.graph.addEdge((Edge)new DroolsDirectedEdge(this.parentVertex, vertex));
        }
    }

    private void visitNode(Object object) {
        this.visit(object);
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }

    public static String dumpConstraints(FieldConstraint[] fieldConstraintArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = fieldConstraintArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(fieldConstraintArray[i].toString() + "<br>");
        }
        return stringBuffer.toString();
    }

    public static abstract class BaseNodeVertex
    extends DirectedSparseVertex
    implements ReteooJungViewer.DroolsVertex {
        public String getHtml() {
            return this.getClass().getName().toString();
        }

        public Paint getFillPaint() {
            return Color.WHITE;
        }

        public Paint getDrawPaint() {
            return Color.BLACK;
        }
    }

    static class TerminalNodeVertex
    extends BaseNodeVertex {
        private final TerminalNode node;

        public TerminalNodeVertex(TerminalNode terminalNode) {
            this.node = terminalNode;
        }

        public String getHtml() {
            return "TerminalNode : " + this.node.getId() + " : " + this.node.getRule();
        }

        public String toString() {
            return "TerminalNode";
        }

        public Paint getFillPaint() {
            return Color.DARK_GRAY;
        }
    }

    static class EvalConditionNodeVertex
    extends BaseNodeVertex {
        private final EvalConditionNode node;

        public EvalConditionNodeVertex(EvalConditionNode evalConditionNode) {
            this.node = evalConditionNode;
        }

        public String getHtml() {
            return "EvalConditionNode : " + this.node.getId();
        }

        public String toString() {
            return "EvalConditionNode";
        }
    }

    static class NotNodeVertex
    extends BaseNodeVertex {
        private final NotNode node;

        public NotNodeVertex(NotNode notNode) {
            this.node = notNode;
        }

        public String getHtml() {
            return "NotNode : " + this.node.getId();
        }

        public String toString() {
            return "NotNode";
        }

        public Paint getFillPaint() {
            return Color.CYAN;
        }
    }

    static class JoinNodeVertex
    extends BaseNodeVertex {
        private final JoinNode node;

        public JoinNodeVertex(JoinNode joinNode) {
            this.node = joinNode;
        }

        public String getHtml() {
            return "JoinNode<br> " + ReteooToJungVisitor.dumpConstraints(this.node.getConstraints());
        }

        public String toString() {
            return "JoinNode";
        }

        public Paint getFillPaint() {
            return Color.GREEN;
        }
    }

    static class RightInputAdapterNodeVertex
    extends BaseNodeVertex {
        private final RightInputAdapterNode node;

        public RightInputAdapterNodeVertex(RightInputAdapterNode rightInputAdapterNode) {
            this.node = rightInputAdapterNode;
        }

        public String getHtml() {
            return "RightInputAdapterNode";
        }

        public String toString() {
            return "RightInputAdapterNode";
        }

        public Paint getFillPaint() {
            return Color.ORANGE;
        }
    }

    static class LeftInputAdapterNodeVertex
    extends BaseNodeVertex {
        private final LeftInputAdapterNode node;

        public LeftInputAdapterNodeVertex(LeftInputAdapterNode leftInputAdapterNode) {
            this.node = leftInputAdapterNode;
        }

        public String getHtml() {
            return "LeftInputAdapterNode<br>" + ReteooToJungVisitor.dumpConstraints(this.node.getConstraints());
        }

        public String toString() {
            return this.node.toString();
        }

        public Paint getFillPaint() {
            return Color.YELLOW;
        }
    }

    static class AlphaNodeVertex
    extends BaseNodeVertex {
        private final AlphaNode node;

        public AlphaNodeVertex(AlphaNode alphaNode) {
            this.node = alphaNode;
        }

        public String getHtml() {
            LiteralConstraint literalConstraint = (LiteralConstraint)this.node.getConstraint();
            ClassFieldExtractor classFieldExtractor = (ClassFieldExtractor)literalConstraint.getFieldExtractor();
            return "AlphaNode<br>field : " + classFieldExtractor.getFieldName() + "<br>evaluator : " + literalConstraint.getEvaluator() + "<br>value :  " + literalConstraint.getField();
        }

        public String toString() {
            return this.node.toString();
        }

        public Paint getFillPaint() {
            return Color.BLUE;
        }
    }

    static class ObjectTypeNodeVertex
    extends BaseNodeVertex {
        private final ObjectTypeNode node;

        public ObjectTypeNodeVertex(ObjectTypeNode objectTypeNode) {
            this.node = objectTypeNode;
        }

        public String getHtml() {
            return "ObjectTypeNode : " + this.node.getObjectType();
        }

        public String toString() {
            return "ObjectTypeNode";
        }

        public Paint getFillPaint() {
            return Color.RED;
        }
    }

    static class ReteNodeVertex
    extends BaseNodeVertex {
        private final Rete node;

        public ReteNodeVertex(Rete rete) {
            this.node = rete;
        }

        public String getHtml() {
            return "Rete : " + this.node.getId();
        }

        public String toString() {
            return "Rete";
        }
    }

    class DroolsDirectedEdge
    extends DirectedSparseEdge {
        public DroolsDirectedEdge(Vertex vertex, Vertex vertex2) {
            super(vertex, vertex2);
        }
    }
}

