/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.event.ObjectAssertedEvent;
import org.drools.event.ObjectModifiedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.spi.PropagationContext;

public class WorkingMemoryEventSupport
implements Serializable {
    private static final long serialVersionUID = -7572714148615479288L;
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final WorkingMemory workingMemory;

    public WorkingMemoryEventSupport(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void addEventListener(WorkingMemoryEventListener workingMemoryEventListener) {
        if (!this.listeners.contains(workingMemoryEventListener)) {
            this.listeners.add(workingMemoryEventListener);
        }
    }

    public void removeEventListener(WorkingMemoryEventListener workingMemoryEventListener) {
        this.listeners.remove(workingMemoryEventListener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireObjectAsserted(PropagationContext propagationContext, FactHandle factHandle, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectAssertedEvent objectAssertedEvent = new ObjectAssertedEvent(this.workingMemory, propagationContext, factHandle, object);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectAsserted(objectAssertedEvent);
        }
    }

    public void fireObjectModified(PropagationContext propagationContext, FactHandle factHandle, Object object, Object object2) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectModifiedEvent objectModifiedEvent = new ObjectModifiedEvent(this.workingMemory, propagationContext, factHandle, object, object2);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectModified(objectModifiedEvent);
        }
    }

    public void fireObjectRetracted(PropagationContext propagationContext, FactHandle factHandle, Object object) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectRetractedEvent objectRetractedEvent = new ObjectRetractedEvent(this.workingMemory, propagationContext, factHandle, object);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((WorkingMemoryEventListener)this.listeners.get(i)).objectRetracted(objectRetractedEvent);
        }
    }
}

