/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.Proxy;
import org.jboss.seam.ioc.IoCComponent;
import org.jboss.seam.ioc.ProxyUtils;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringComponent
extends IoCComponent {
    private static final String SPRING_COMPONENT_NAME_MAP = "org.jboss.seam.SpringComponentNameMap";
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = IoCComponent.class.getName() + ".DESTRUCTION_CALLBACK.";
    private BeanFactory beanfactory;
    private InterceptionType interceptionType;
    private String springBeanName;
    private static final ThreadLocal<ObjectFactory> objectFactory = new ThreadLocal();

    public static ObjectFactory getObjectFactory() {
        return objectFactory.get();
    }

    public static void setObjectFactory(ObjectFactory bean) {
        objectFactory.set(bean);
    }

    public static void addSpringComponent(String componentName, String springBeanName, String beanClassName, ScopeType scopeType, BeanFactory beanFactory, InterceptionType interceptorType) {
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.mockApplication();
            unmockApplication = true;
        }
        try {
            if (Component.forName((String)componentName) != null) {
                throw new IllegalStateException("Cannot add spring component to seam with name: " + componentName + ".  There is already a seam component with that name.");
            }
            Map<String, String> springComponentNameMap = SpringComponent.getSpringComponentNameMap();
            springComponentNameMap.put(springBeanName, componentName);
            Class beanClass = ClassUtils.forName((String)beanClassName);
            Contexts.getApplicationContext().set(componentName + ".component", (Object)new SpringComponent(beanClass, componentName, springBeanName, scopeType, beanFactory, interceptorType));
        }
        catch (ClassNotFoundException e) {
            throw new FatalBeanException("Error", (Throwable)e);
        }
        finally {
            if (unmockApplication) {
                Lifecycle.unmockApplication();
            }
        }
    }

    private static Map<String, String> getSpringComponentNameMap() {
        if (Contexts.getApplicationContext().get(SPRING_COMPONENT_NAME_MAP) == null) {
            Contexts.getApplicationContext().set(SPRING_COMPONENT_NAME_MAP, new HashMap());
        }
        return (Map)Contexts.getApplicationContext().get(SPRING_COMPONENT_NAME_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpringComponent forSpringBeanName(String springBeanName) {
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.mockApplication();
            unmockApplication = true;
        }
        try {
            SpringComponent springComponent = (SpringComponent)Component.forName((String)SpringComponent.getSpringComponentNameMap().get(springBeanName));
            return springComponent;
        }
        finally {
            if (unmockApplication) {
                Lifecycle.unmockApplication();
            }
        }
    }

    public SpringComponent(Class clazz, String componentName, String springBeanName, ScopeType scope, BeanFactory factory, InterceptionType interception) {
        super(clazz, componentName, scope);
        this.springBeanName = springBeanName;
        this.beanfactory = factory;
        this.interceptionType = interception;
    }

    @Override
    protected String getIoCName() {
        return "Spring";
    }

    @Override
    protected Object instantiateIoCBean() throws Exception {
        ObjectFactory objectFactory = SpringComponent.getObjectFactory();
        if (objectFactory == null) {
            return this.beanfactory.getBean(this.springBeanName);
        }
        SpringComponent.setObjectFactory(null);
        Object bean = objectFactory.getObject();
        if (this.getInterceptionType() == InterceptionType.NEVER) {
            if (this.getScope() != ScopeType.STATELESS) {
                this.callPostConstructMethod(bean);
            }
        } else if (!(bean instanceof Proxy)) {
            HashSet<Class> interfaces = new HashSet<Class>(Arrays.asList(bean.getClass().getInterfaces()));
            interfaces.add(HttpSessionActivationListener.class);
            interfaces.add(Mutable.class);
            interfaces.add(Proxy.class);
            bean = ProxyUtils.enhance(bean, interfaces, this);
        }
        return bean;
    }

    protected Object instantiateJavaBean() throws Exception {
        return this.instantiateIoCBean();
    }

    public void callDestroyMethod(Object instance) {
        Runnable callback;
        super.callDestroyMethod(instance);
        if (this.getScope() != ScopeType.STATELESS && (callback = (Runnable)this.getScope().getContext().get(DESTRUCTION_CALLBACK_NAME_PREFIX + this.getName())) != null) {
            callback.run();
        }
    }

    public void registerDestroyCallback(String name, Runnable destroy) {
        if (this.getScope() != ScopeType.STATELESS) {
            this.getScope().getContext().set(DESTRUCTION_CALLBACK_NAME_PREFIX + name, (Object)destroy);
        }
    }

    public void inject(Object bean, boolean enforceRequired) {
        if (bean instanceof Advised) {
            try {
                this.inject(((Advised)bean).getTargetSource().getTarget(), enforceRequired);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        super.inject(bean, enforceRequired);
    }

    public InterceptionType getInterceptionType() {
        if (this.interceptionType == null) {
            return super.getInterceptionType();
        }
        return this.interceptionType;
    }
}

