/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.Proxy;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamTargetSource
implements TargetSource,
Serializable {
    private ScopeType scope;
    private String name;
    private Boolean create;
    private Expressions.ValueBinding valueBinding;

    public SeamTargetSource(String name, ScopeType scope, Boolean create) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Name is required.");
        }
        this.name = name;
        this.scope = scope;
        this.create = create;
        if (name.startsWith("#")) {
            this.valueBinding = Expressions.instance().createValueBinding(name);
        }
    }

    public Object getTarget() throws Exception {
        if (this.valueBinding != null) {
            return this.valueBinding.getValue();
        }
        if (this.scope == null && this.create == null) {
            return Component.getInstance((String)this.name);
        }
        if (this.scope == null) {
            return Component.getInstance((String)this.name, (boolean)this.create);
        }
        if (this.create == null) {
            return Component.getInstance((String)this.name, (ScopeType)this.scope);
        }
        return Component.getInstance((String)this.name, (ScopeType)this.scope, (boolean)this.create);
    }

    public Class getTargetClass() {
        Class trueClass = this.getTrueTargetClass();
        if (trueClass == null) {
            return null;
        }
        if (trueClass.isInterface()) {
            return Object.class;
        }
        return trueClass;
    }

    public Class getTrueTargetClass() {
        Component component = this.getComponent();
        if (component == null) {
            return null;
        }
        if (component.hasUnwrapMethod()) {
            return component.getUnwrapMethod().getReturnType();
        }
        return component.getBeanClass();
    }

    public List<Class> getSeamInterfaces() {
        Component component;
        ArrayList<Class> interfaces = new ArrayList<Class>();
        Class trueClass = this.getTrueTargetClass();
        if (trueClass == null) {
            return null;
        }
        if (trueClass.isInterface()) {
            interfaces.add(trueClass);
        }
        if ((component = this.getComponent()).getInterceptionType() != InterceptionType.NEVER) {
            if (component.getType().isSessionBean()) {
                interfaces.addAll(component.getBusinessInterfaces());
            } else {
                interfaces.add(HttpSessionActivationListener.class);
                interfaces.add(Mutable.class);
            }
            interfaces.add(Proxy.class);
        }
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        if (this.valueBinding != null) {
            return null;
        }
        boolean unmockApplication = false;
        if (!Contexts.isApplicationContextActive()) {
            Lifecycle.mockApplication();
            unmockApplication = true;
        }
        try {
            Component component = Component.forName((String)this.name);
            if (component == null) {
                throw new IllegalStateException("Cannot find targetClass for seam component: " + this.name + ".  Make sure Seam is being configured before Spring.");
            }
            Component component2 = component;
            return component2;
        }
        finally {
            if (unmockApplication) {
                Lifecycle.unmockApplication();
            }
        }
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }
}

