/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.simple;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.net.URI;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;

public class SimpleDiscoveryAgent
implements DiscoveryAgent {
    private long initialReconnectDelay = 5000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = false;
    private int maxReconnectAttempts;
    private final Object sleepMutex = new Object();
    private long minConnectTime = 500L;
    private DiscoveryListener listener;
    String[] services = new String[0];
    String group = "DEFAULT";
    private final AtomicBoolean running = new AtomicBoolean(false);

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public void registerService(String name) throws IOException {
    }

    public void start() throws Exception {
        this.running.set(true);
        for (int i = 0; i < this.services.length; ++i) {
            this.listener.onServiceAdd(new SimpleDiscoveryEvent(this.services[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        this.running.set(false);
        Object object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notifyAll();
        }
    }

    public String[] getServices() {
        return this.services;
    }

    public void setServices(String services) {
        this.services = services.split(",");
    }

    public void setServices(String[] services) {
        this.services = services;
    }

    public void setServices(URI[] services) {
        this.services = new String[services.length];
        for (int i = 0; i < services.length; ++i) {
            this.services[i] = services[i].toString();
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setBrokerName(String brokerName) {
    }

    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.listener.onServiceRemove(event);
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (event.connectTime + SimpleDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                        event.connectFailures++;
                        if (SimpleDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= SimpleDiscoveryAgent.this.maxReconnectAttempts) {
                            return;
                        }
                        Object object = SimpleDiscoveryAgent.this.sleepMutex;
                        synchronized (object) {
                            try {
                                if (!SimpleDiscoveryAgent.this.running.get()) {
                                    return;
                                }
                                SimpleDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        if (!SimpleDiscoveryAgent.this.useExponentialBackOff) {
                            event.reconnectDelay = SimpleDiscoveryAgent.this.initialReconnectDelay;
                        } else {
                            event.reconnectDelay *= SimpleDiscoveryAgent.this.backOffMultiplier;
                            if (event.reconnectDelay > SimpleDiscoveryAgent.this.maxReconnectDelay) {
                                event.reconnectDelay = SimpleDiscoveryAgent.this.maxReconnectDelay;
                            }
                        }
                    } else {
                        event.connectFailures = 0;
                        event.reconnectDelay = SimpleDiscoveryAgent.this.initialReconnectDelay;
                    }
                    if (!SimpleDiscoveryAgent.this.running.get()) {
                        return;
                    }
                    event.connectTime = System.currentTimeMillis();
                    event.failed.set(false);
                    SimpleDiscoveryAgent.this.listener.onServiceAdd(event);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    public long getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(long backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getMinConnectTime() {
        return this.minConnectTime;
    }

    public void setMinConnectTime(long minConnectTime) {
        this.minConnectTime = minConnectTime;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = SimpleDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
        }
    }
}

