/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.multicast;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastDiscoveryAgent
implements DiscoveryAgent,
Runnable {
    private static final Log log = LogFactory.getLog((Class)MulticastDiscoveryAgent.class);
    public static final String DEFAULT_DISCOVERY_URI_STRING = "multicast://239.255.2.3:6155";
    private static final String TYPE_SUFFIX = "ActiveMQ-4.";
    private static final String ALIVE = "alive.";
    private static final String DEAD = "dead.";
    private static final String DELIMITER = "%";
    private static final int BUFF_SIZE = 8192;
    private static final int DEFAULT_IDLE_TIME = 500;
    private static final int HEARTBEAT_MISS_BEFORE_DEATH = 4;
    private int timeToLive = 1;
    private boolean loopBackMode = false;
    private Map services = new ConcurrentHashMap();
    private Map brokers = new ConcurrentHashMap();
    private String group = "default";
    private String brokerName;
    private URI discoveryURI;
    private InetAddress inetAddress;
    private SocketAddress sockAddress;
    private DiscoveryListener discoveryListener;
    private String selfService;
    private MulticastSocket mcast;
    private Thread runner;
    private long keepAliveInterval = 500L;
    private long lastAdvertizeTime = 0L;
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean reportAdvertizeFailed = true;
    private final Executor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

        public Thread newThread(Runnable runable) {
            Thread t = new Thread(runable, "Multicast Discovery Agent Notifier");
            t.setDaemon(true);
            return t;
        }
    });

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.discoveryListener = listener;
    }

    public void registerService(String name) throws IOException {
        this.selfService = name;
        if (this.started.get()) {
            this.doAdvertizeSelf();
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        if (brokerName != null) {
            brokerName = brokerName.replace('.', '-');
            brokerName = brokerName.replace(':', '-');
            this.brokerName = brokerName = brokerName.replace('%', '-');
        }
    }

    public boolean isLoopBackMode() {
        return this.loopBackMode;
    }

    public void setLoopBackMode(boolean loopBackMode) {
        this.loopBackMode = loopBackMode;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public URI getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setDiscoveryURI(URI discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            String type;
            if (this.group == null || this.group.length() == 0) {
                throw new IOException("You must specify a group to discover");
            }
            if (this.brokerName == null || this.brokerName.length() == 0) {
                log.warn((Object)"brokerName not set");
            }
            if (!(type = this.getType()).endsWith(".")) {
                log.warn((Object)("The type '" + type + "' should end with '.' to be a valid Discovery type"));
                type = type + ".";
            }
            if (this.discoveryURI == null) {
                this.discoveryURI = new URI(DEFAULT_DISCOVERY_URI_STRING);
            }
            this.inetAddress = InetAddress.getByName(this.discoveryURI.getHost());
            this.sockAddress = new InetSocketAddress(this.inetAddress, this.discoveryURI.getPort());
            this.mcast = new MulticastSocket(this.discoveryURI.getPort());
            this.mcast.setLoopbackMode(this.loopBackMode);
            this.mcast.setTimeToLive(this.getTimeToLive());
            this.mcast.joinGroup(this.inetAddress);
            this.mcast.setSoTimeout((int)this.keepAliveInterval);
            this.runner = new Thread(this);
            this.runner.setName("MulticastDiscovery: " + this.selfService);
            this.runner.setDaemon(true);
            this.runner.start();
            this.doAdvertizeSelf();
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.doAdvertizeSelf();
            this.mcast.close();
        }
    }

    public String getType() {
        return this.group + "." + TYPE_SUFFIX;
    }

    public void run() {
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (this.started.get()) {
            this.doTimeKeepingServices();
            try {
                this.mcast.receive(packet);
                if (packet.getLength() <= 0) continue;
                String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                this.processData(str);
            }
            catch (SocketTimeoutException se) {
            }
            catch (IOException e) {
                if (!this.started.get()) continue;
                log.error((Object)("failed to process packet: " + e));
            }
        }
    }

    private void processData(String str) {
        if (this.discoveryListener != null && str.startsWith(this.getType())) {
            String payload = str.substring(this.getType().length());
            if (payload.startsWith(ALIVE)) {
                String brokerName = this.getBrokerName(payload.substring(ALIVE.length()));
                String service = payload.substring(ALIVE.length() + brokerName.length() + 2);
                if (!brokerName.equals(this.brokerName)) {
                    this.processAlive(brokerName, service);
                }
            } else {
                String brokerName = this.getBrokerName(payload.substring(DEAD.length()));
                String service = payload.substring(DEAD.length() + brokerName.length() + 2);
                if (!brokerName.equals(this.brokerName)) {
                    this.processDead(brokerName, service);
                }
            }
        }
    }

    private void doTimeKeepingServices() {
        if (this.started.get()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.keepAliveInterval > this.lastAdvertizeTime) {
                this.doAdvertizeSelf();
                this.lastAdvertizeTime = currentTime;
            }
            this.doExpireOldServices();
        }
    }

    private void doAdvertizeSelf() {
        block3: {
            if (this.selfService != null) {
                String payload = this.getType();
                payload = payload + (this.started.get() ? ALIVE : DEAD);
                payload = payload + DELIMITER + this.brokerName + DELIMITER;
                payload = payload + this.selfService;
                try {
                    byte[] data = payload.getBytes();
                    DatagramPacket packet = new DatagramPacket(data, 0, data.length, this.sockAddress);
                    this.mcast.send(packet);
                }
                catch (IOException e) {
                    if (!this.reportAdvertizeFailed) break block3;
                    this.reportAdvertizeFailed = false;
                    log.error((Object)("Failed to advertise our service: " + payload), (Throwable)e);
                    if (!"Operation not permitted".equals(e.getMessage())) break block3;
                    log.error((Object)("The 'Operation not permitted' error has been know to be caused by improper firewall/network setup.  Please make sure that the OS is properly configured to allow multicast traffic over: " + this.mcast.getLocalAddress()));
                }
            }
        }
    }

    private void processAlive(String brokerName, String service) {
        if (this.selfService == null || !service.equals(this.selfService)) {
            AtomicLong lastKeepAlive = (AtomicLong)this.services.get(service);
            if (lastKeepAlive == null) {
                this.brokers.put(service, brokerName);
                if (this.discoveryListener != null) {
                    final DiscoveryEvent event = new DiscoveryEvent(service);
                    event.setBrokerName(brokerName);
                    this.executor.execute(new Runnable(){

                        public void run() {
                            DiscoveryListener discoveryListener = MulticastDiscoveryAgent.this.discoveryListener;
                            if (discoveryListener != null) {
                                discoveryListener.onServiceAdd(event);
                            }
                        }
                    });
                }
                lastKeepAlive = new AtomicLong(System.currentTimeMillis());
                this.services.put(service, lastKeepAlive);
                this.doAdvertizeSelf();
            }
            lastKeepAlive.set(System.currentTimeMillis());
        }
    }

    private void processDead(String brokerName, String service) {
        if (!service.equals(this.selfService) && this.services.remove(service) != null) {
            this.brokers.remove(service);
            if (this.discoveryListener != null) {
                final DiscoveryEvent event = new DiscoveryEvent(service);
                event.setBrokerName(brokerName);
                this.executor.execute(new Runnable(){

                    public void run() {
                        DiscoveryListener discoveryListener = MulticastDiscoveryAgent.this.discoveryListener;
                        if (discoveryListener != null) {
                            discoveryListener.onServiceRemove(event);
                        }
                    }
                });
            }
        }
    }

    private void doExpireOldServices() {
        long expireTime = System.currentTimeMillis() - this.keepAliveInterval * 4L;
        Iterator i = this.services.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            AtomicLong lastHeartBeat = (AtomicLong)entry.getValue();
            if (lastHeartBeat.get() >= expireTime) continue;
            String brokerName = (String)this.brokers.get(entry.getKey());
            this.processDead(brokerName, entry.getKey().toString());
        }
    }

    private String getBrokerName(String str) {
        String result = null;
        int start = str.indexOf(DELIMITER);
        if (start >= 0) {
            int end = str.indexOf(DELIMITER, start + 1);
            result = str.substring(start + 1, end);
        }
        return result;
    }

    public void serviceFailed(DiscoveryEvent event) throws IOException {
        this.processDead(event.getBrokerName(), event.getServiceName());
    }
}

