/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;

public class MemoryMessageStore
implements MessageStore {
    protected final ActiveMQDestination destination;
    protected final Map messageTable;
    static /* synthetic */ Class class$java$lang$String;

    public MemoryMessageStore(ActiveMQDestination destination) {
        this(destination, new LinkedHashMap());
    }

    public MemoryMessageStore(ActiveMQDestination destination, Map messageTable) {
        this.destination = destination;
        this.messageTable = Collections.synchronizedMap(messageTable);
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        this.messageTable.put(message.getMessageId(), message);
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.messageTable.put(messageId, messageRef);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return (Message)this.messageTable.get(identity);
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return (String)this.messageTable.get(identity);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.messageTable.remove(ack.getLastMessageId());
    }

    public void removeMessage(MessageId msgId) throws IOException {
        this.messageTable.remove(msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(MessageRecoveryListener listener) throws Exception {
        Map map = this.messageTable;
        synchronized (map) {
            Iterator iter = this.messageTable.values().iterator();
            while (iter.hasNext()) {
                Object msg = iter.next();
                if (msg.getClass() == (class$java$lang$String == null ? MemoryMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                    listener.recoverMessageReference((String)msg);
                    continue;
                }
                listener.recoverMessage((Message)msg);
            }
            listener.finished();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageTable.clear();
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void delete() {
        this.messageTable.clear();
    }

    public void setUsageManager(UsageManager usageManager) {
    }
}

