/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;

public class KahaMessageStore
implements MessageStore {
    protected final ActiveMQDestination destination;
    protected final MapContainer messageContainer;
    static /* synthetic */ Class class$java$lang$String;

    public KahaMessageStore(MapContainer container, ActiveMQDestination destination) throws IOException {
        this.messageContainer = container;
        this.destination = destination;
    }

    public Object getId() {
        return this.messageContainer.getId();
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        this.messageContainer.put(message.getMessageId().toString(), message);
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.messageContainer.put(messageId.toString(), messageRef);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return (Message)this.messageContainer.get(identity.toString());
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return (String)this.messageContainer.get(identity.toString());
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.messageContainer.remove(ack.getLastMessageId().toString());
    }

    public void removeMessage(MessageId msgId) throws IOException {
        this.messageContainer.remove(msgId.toString());
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        Iterator iter = this.messageContainer.values().iterator();
        while (iter.hasNext()) {
            Object msg = iter.next();
            if (msg.getClass() == (class$java$lang$String == null ? KahaMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                listener.recoverMessageReference((String)msg);
                continue;
            }
            listener.recoverMessage((Message)msg);
        }
        listener.finished();
    }

    public void start() {
    }

    public void stop() {
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void delete() {
        this.messageContainer.clear();
    }

    public void setUsageManager(UsageManager usageManager) {
    }
}

