/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.journal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.journal.QuickJournalMessageStore;
import org.apache.activemq.store.journal.QuickJournalPersistenceAdapter;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuickJournalTopicMessageStore
extends QuickJournalMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)QuickJournalTopicMessageStore.class);
    private TopicMessageStore longTermStore;
    private HashMap ackedLastAckLocations = new HashMap();

    public QuickJournalTopicMessageStore(QuickJournalPersistenceAdapter adapter, TopicMessageStore checkpointStore, ActiveMQTopic destinationName) {
        super(adapter, checkpointStore, destinationName);
        this.longTermStore = checkpointStore;
    }

    public void recoverSubscription(String clientId, String subscriptionName, final MessageRecoveryListener listener) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.recoverSubscription(clientId, subscriptionName, new MessageRecoveryListener(){

            public void recoverMessage(Message message) throws Exception {
                throw new IOException("Should not get called.");
            }

            public void recoverMessageReference(String messageReference) throws Exception {
                RecordLocation loc = QuickJournalMessageStore.toRecordLocation(messageReference);
                Message message = (Message)QuickJournalTopicMessageStore.this.peristenceAdapter.readCommand(loc);
                listener.recoverMessage(message);
            }

            public void finished() {
                listener.finished();
            }
        });
    }

    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, final MessageRecoveryListener listener) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.recoverNextMessages(clientId, subscriptionName, lastMessageId, maxReturned, new MessageRecoveryListener(){

            public void recoverMessage(Message message) throws Exception {
                throw new IOException("Should not get called.");
            }

            public void recoverMessageReference(String messageReference) throws Exception {
                RecordLocation loc = QuickJournalMessageStore.toRecordLocation(messageReference);
                Message message = (Message)QuickJournalTopicMessageStore.this.peristenceAdapter.readCommand(loc);
                listener.recoverMessage(message);
            }

            public void finished() {
                listener.finished();
            }
        });
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.longTermStore.lookupSubscription(clientId, subscriptionName);
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.addSubsciption(clientId, subscriptionName, selector, retroactive);
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        super.addMessage(context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, final MessageId messageId) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalTopicAck ack = new JournalTopicAck();
        ack.setDestination(this.destination);
        ack.setMessageId(messageId);
        ack.setMessageSequenceId(messageId.getBrokerSequenceId());
        ack.setSubscritionName(subscriptionName);
        ack.setClientId(clientId);
        ack.setTransactionId(context.getTransaction() != null ? context.getTransaction().getTransactionId() : null);
        final RecordLocation location = this.peristenceAdapter.writeCommand(ack, false);
        final SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled acknowledge for: " + messageId + ", at: " + location));
            }
            this.acknowledge(messageId, location, key);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted acknowledge for: " + messageId + ", at: " + location));
            }
            QuickJournalTopicMessageStore quickJournalTopicMessageStore = this;
            synchronized (quickJournalTopicMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.acknowledge(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted acknowledge commit for: " + messageId + ", at: " + location));
                    }
                    QuickJournalTopicMessageStore quickJournalTopicMessageStore = QuickJournalTopicMessageStore.this;
                    synchronized (quickJournalTopicMessageStore) {
                        QuickJournalTopicMessageStore.this.inFlightTxLocations.remove(location);
                        QuickJournalTopicMessageStore.this.acknowledge(messageId, location, key);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted acknowledge rollback for: " + messageId + ", at: " + location));
                    }
                    QuickJournalTopicMessageStore quickJournalTopicMessageStore = QuickJournalTopicMessageStore.this;
                    synchronized (quickJournalTopicMessageStore) {
                        QuickJournalTopicMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    public void replayAcknowledge(ConnectionContext context, String clientId, String subscritionName, MessageId messageId) {
        try {
            SubscriptionInfo sub = this.longTermStore.lookupSubscription(clientId, subscritionName);
            if (sub != null) {
                this.longTermStore.acknowledge(context, clientId, subscritionName, messageId);
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Could not replay acknowledge for message '" + messageId + "'.  Message may have already been acknowledged. reason: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(MessageId messageId, RecordLocation location, SubscriptionKey key) {
        QuickJournalTopicMessageStore quickJournalTopicMessageStore = this;
        synchronized (quickJournalTopicMessageStore) {
            this.lastLocation = location;
            this.ackedLastAckLocations.put(key, messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        HashMap cpAckedLastAckLocations;
        QuickJournalTopicMessageStore quickJournalTopicMessageStore = this;
        synchronized (quickJournalTopicMessageStore) {
            cpAckedLastAckLocations = this.ackedLastAckLocations;
            this.ackedLastAckLocations = new HashMap();
        }
        return super.checkpoint(new Callback(){

            public void execute() throws Exception {
                Iterator iterator = cpAckedLastAckLocations.keySet().iterator();
                while (iterator.hasNext()) {
                    SubscriptionKey subscriptionKey = (SubscriptionKey)iterator.next();
                    MessageId identity = (MessageId)cpAckedLastAckLocations.get(subscriptionKey);
                    QuickJournalTopicMessageStore.this.longTermStore.acknowledge(QuickJournalTopicMessageStore.this.transactionTemplate.getContext(), subscriptionKey.clientId, subscriptionKey.subscriptionName, identity);
                }
            }
        });
    }

    public TopicMessageStore getLongTermTopicMessageStore() {
        return this.longTermStore;
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        this.longTermStore.deleteSubscription(clientId, subscriptionName);
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.longTermStore.getAllSubscriptions();
    }

    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        return this.longTermStore.getNextMessageIdToDeliver(clientId, subscriptionName, id);
    }

    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        this.peristenceAdapter.checkpoint(true, true);
        return this.longTermStore.getPreviousMessageIdToDeliver(clientId, subscriptionName, id);
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        this.peristenceAdapter.checkpoint(true, true);
        return this.longTermStore.getMessageCount(clientId, subscriberName);
    }

    public void resetBatching(String clientId, String subscriptionName, MessageId nextId) {
        this.longTermStore.resetBatching(clientId, subscriptionName, nextId);
    }
}

