/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.DatabaseLocker;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDatabaseLocker
implements DatabaseLocker {
    private static final Log log = LogFactory.getLog((Class)DefaultDatabaseLocker.class);
    private final DataSource dataSource;
    private final Statements statements;
    private long sleepTime = 1000L;
    private Connection connection;
    private boolean stopping;

    public DefaultDatabaseLocker(DataSource dataSource, Statements statements) {
        this.dataSource = dataSource;
        this.statements = statements;
    }

    public void start() throws Exception {
        this.stopping = false;
        this.connection = this.dataSource.getConnection();
        this.connection.setAutoCommit(false);
        PreparedStatement statement = this.connection.prepareStatement(this.statements.getLockCreateStatement());
        while (true) {
            try {
                log.info((Object)"Attempting to acquire the exclusive lock to become the Master broker");
                boolean answer = statement.execute();
                if (answer) {
                    break;
                }
            }
            catch (Exception e) {
                if (this.stopping) {
                    throw new Exception("Cannot start broker as being asked to shut down. Interupted attempt to acquire lock: " + e, e);
                }
                log.error((Object)("Failed to acquire lock: " + e), (Throwable)e);
            }
            log.debug((Object)("Sleeping for " + this.sleepTime + " milli(s) before trying again to get the lock..."));
            Thread.sleep(this.sleepTime);
        }
        log.info((Object)("Becoming the master on dataSource: " + this.dataSource));
    }

    public void stop() throws Exception {
        this.stopping = true;
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
        }
    }

    public boolean keepAlive() {
        try {
            PreparedStatement statement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
            statement.setLong(1, System.currentTimeMillis());
            int rows = statement.executeUpdate();
            if (rows == 1) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to update database lock: " + e), (Throwable)e);
        }
        return false;
    }
}

