/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.TopicMessageStore;

public class ProxyTopicMessageStore
implements TopicMessageStore {
    final TopicMessageStore delegate;

    public ProxyTopicMessageStore(TopicMessageStore delegate) {
        this.delegate = delegate;
    }

    public MessageStore getDelegate() {
        return this.delegate;
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        this.delegate.addMessage(context, message);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return this.delegate.getMessage(identity);
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        this.delegate.recover(listener);
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.delegate.removeAllMessages(context);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.delegate.removeMessage(context, ack);
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() throws Exception {
        this.delegate.stop();
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.delegate.lookupSubscription(clientId, subscriptionName);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        this.delegate.acknowledge(context, clientId, subscriptionName, messageId);
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        this.delegate.addSubsciption(clientId, subscriptionName, selector, retroactive);
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        this.delegate.deleteSubscription(clientId, subscriptionName);
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        this.delegate.recoverSubscription(clientId, subscriptionName, listener);
    }

    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, MessageRecoveryListener listener) throws Exception {
        this.delegate.recoverNextMessages(clientId, subscriptionName, lastMessageId, maxReturned, listener);
    }

    public void resetBatching(String clientId, String subscriptionName, MessageId id) {
        this.delegate.resetBatching(clientId, subscriptionName, id);
    }

    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        return this.delegate.getNextMessageIdToDeliver(clientId, subscriptionName, id);
    }

    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws Exception {
        return this.delegate.getPreviousMessageIdToDeliver(clientId, subscriptionName, id);
    }

    public ActiveMQDestination getDestination() {
        return this.delegate.getDestination();
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.delegate.addMessageReference(context, messageId, expirationTime, messageRef);
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return this.delegate.getMessageReference(identity);
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.delegate.getAllSubscriptions();
    }

    public void setUsageManager(UsageManager usageManager) {
        this.delegate.setUsageManager(usageManager);
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        return this.delegate.getMessageCount(clientId, subscriberName);
    }
}

