/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.util.Iterator;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableConduitBridge
extends ConduitBridge {
    private static final Log log = LogFactory.getLog((Class)DurableConduitBridge.class);

    public DurableConduitBridge(Transport localBroker, Transport remoteBroker) {
        super(localBroker, remoteBroker);
    }

    protected void setupStaticDestinations() {
        super.setupStaticDestinations();
        ActiveMQDestination[] dests = this.durableDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                ActiveMQDestination dest = dests[i];
                if (!this.isPermissableDestination(dest) || this.doesConsumerExist(dest)) continue;
                DemandSubscription sub = this.createDemandSubscription(dest);
                if (dest.isTopic()) {
                    sub.getLocalInfo().setSubscriptionName(this.getSubscriberName(dest));
                }
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to add static destination " + dest), (Throwable)e);
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Forwarding messages for durable destination: " + dest));
            }
        }
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        if (info.isDurable() || info.getDestination().isQueue() && !info.getDestination().isTemporary()) {
            info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        }
        if (info.isDurable()) {
            info.setSubscriptionName(this.getSubscriberName(info.getDestination()));
        }
        return this.doCreateDemandSubscription(info);
    }

    protected String getSubscriberName(ActiveMQDestination dest) {
        String subscriberName = this.getLocalBrokerName() + "_" + dest.getPhysicalName();
        return subscriberName;
    }

    protected boolean doesConsumerExist(ActiveMQDestination dest) {
        DestinationFilter filter = DestinationFilter.parseFilter(dest);
        Iterator i = this.subscriptionMapByLocalId.values().iterator();
        while (i.hasNext()) {
            DemandSubscription ds = (DemandSubscription)i.next();
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            return true;
        }
        return false;
    }
}

