/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.util.ListIterator;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.container.ListContainerImpl;

public class CachedContainerListIterator
implements ListIterator {
    protected ListContainerImpl container;
    protected int pos = 0;
    protected int nextPos = 0;
    protected StoreEntry currentItem;

    protected CachedContainerListIterator(ListContainerImpl container, int start) {
        this.container = container;
        this.nextPos = this.pos = start;
    }

    public boolean hasNext() {
        return this.nextPos >= 0 && this.nextPos < this.container.size();
    }

    public Object next() {
        this.pos = this.nextPos++;
        Object result = this.container.getCachedItem(this.pos);
        return result;
    }

    public void remove() {
        this.container.remove(this.pos);
        --this.nextPos;
    }

    public boolean hasPrevious() {
        return this.pos >= 0 && this.pos < this.container.size();
    }

    public Object previous() {
        Object result = this.container.getCachedItem(this.pos);
        --this.pos;
        return result;
    }

    public int nextIndex() {
        return this.pos + 1;
    }

    public int previousIndex() {
        return this.pos - 1;
    }

    public void set(Object o) {
        this.container.internalSet(this.pos, o);
    }

    public void add(Object o) {
        this.container.internalAdd(this.previousIndex() + 1, o);
    }
}

